<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Models\Role as SpatieRole;

class Role extends SpatieRole
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'spatie_roles'; // <-- this tells Laravel to use the correct table


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = ['id'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function scopeTemplateRole($q, $role_name)
    {
        return $q->where([
            'name' => 'Template_'.$role_name,
            'is_template' => 1
        ]);
    }

    // public function users()
    // {
    //     return $this->belongsToMany(User::class, 'user_roles', 'role_id', 'user_id')
    //                 ->using(UserRole::class)
    //                 ->withPivot('id_user_roles');
    // }
   
    
}
