<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class SMSCred extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'sms_cred'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_sms_cred';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        
        'username',
        'password',
        'domain',
        'status',
        'business_id',
        'mask',
        'channel'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }


}
