<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class ServiceCategory extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'service_category'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_service_category';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id_service_category',
        'business_id',
        'service_type_id',
        'order_id',
        'service_category',        
        'service_category_active',
        'service_category_image',
        
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function service_type()
    {
        return $this->belongsTo(ServiceType::class, 'id_service_category');
    }

    public function business()
    {
        return $this->belongsTo(Business::class, 'id_business');
    }

    public function business_services(){
         return $this->hasMany(Services::class, 'service_category_id');
    }

}
