<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class ServiceType extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'service_type'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_service_types';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id_service_types',
        'business_id',
        'order_id',
        'service_type',        
        'service_type_active',
        'service_type_image',
        'business_type_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];



    public function business()
    {
        return $this->belongsTo(Business::class, 'id_business');
    }

    public function business_services(){
         return $this->hasMany(ServiceCategory::class, 'service_type_id');
    }

}
