<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Services extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'business_services'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_business_services';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'service_category_id',
        'business_id',
        'order_id',
        'service_name',
        'service_desc',
        'created_date',
        'service_rate',
        'service_active',
        'commission_type',
        'commission_perc',
        'commission_fixed',
        'helper_perc',
        'helper_fixed',
        'service_color',
        'service_duration',
        'max_per_day',
        'service_mode',
        'service_department',
        'ref_number',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function service_category()
    {
        return $this->belongsTo(ServiceCategory::class, 'id_service_category');
    }

    public function business()
    {
        return $this->belongsTo(Business::class, 'id_business');
    }

   

}
