<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class ServicesProducts extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'services_products'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_services_products';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       
       'business_service_id',
       'business_product_id',
       'usage_qty',
       'status',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business_services()
    {
        return $this->belongsTo(Services::class, 'id_business_service', 'business_service_id');
    }

    public function products()
    {
        return $this->belongsTo(Products::class, 'id_business_product', 'business_product_id');
    }


}
