<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Staff extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'staff';
    protected $primaryKey = 'id_staff';

    protected $fillable = [
        'business_id',
        'staff_firstname',
        'staff_lastname',
        'staff_fullname',
        'staff_cell',
        'staff_phone1',
        'staff_phone2',
        'staff_address',
        'staff_eid',
        'staff_image',
        'staff_email',
        'staff_active',
        'staff_order',
        'staff_salary',
        'staff_comment',
        'staff_scheduler',
        'staff_shared',
        'fcm_id',
        'staff_work_min',
        'week_day_off',
        'commission_mode',
        'staff_commission_perc',
        'commission_target',
        'commission_fixed_amount',
        'deduction_policy',
        'provident_fund_rate',
        'salary_monthly_tax',
        'staff_designation',
        'staff_department',
        'staff_cnic',
        'staff_date_of_joining',
        'staff_bank_account',
        'staff_bank_account_title',
        'staff_bank',
        'staff_annual_leaves',
        'day_start_time',
        'day_end_time',
        'floor_id',
        'floor',
        'salary_type',
        'next_of_kin_name',
        'next_of_kin_number',
        'date_of_birth',
        'contract_validity',
        'contract_number',
        'staff_fingerprint_template_base64',
        'staff_fingerprint',
        'auto_time_out',
        'leave_policy_id',
        'overtime_allowed',
        'overtime_hourly_rate'
    ];

    protected $hidden = [];
    protected $casts = [];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }
    
    public function invoice_staff()
    {
        return $this->hasMany(InvoiceStaff::class, 'staff_id', 'id_staff');
    }
    public function staffAllowances()
    {
        return $this->hasMany(StaffAllowance::class, 'staff_id', 'id_staff')
            ->where('staff_allowance_status', 'Active');
    }
    //  relationship for all allowances
    public function allStaffAllowances()
    {
        return $this->hasMany(StaffAllowance::class, 'staff_id', 'id_staff');
    }

    // loan Relationship
    public function loanApplications()
    {
        return $this->hasMany(LoanAdvSalary::class, 'staff_id', 'id_staff');
    }

    public function activeLoans()
    {
        return $this->hasMany(LoanAdvSalary::class, 'staff_id', 'id_staff')
            ->whereIn('application_status', ['Approved', 'Disbursed']);
    }

    public function pendingLoans()
    {
        return $this->hasMany(LoanAdvSalary::class, 'staff_id', 'id_staff')
            ->where('application_status', 'Pending');
    }

    // leaves policy relationship
    public function leavePolicy()
    {
        return $this->belongsTo(LeavePolicy::class, 'leave_policy_id', 'id_leave_policy');
    }

    public function getTotalAnnualLeavesAttribute()
    {
        if ($this->leavePolicy && $this->leavePolicy->definitions) {
            return $this->leavePolicy->definitions->sum('allowed_count');
        }
        return $this->staff_annual_leaves ?? 0;
    }

    // deduction policy relationship
     public function deductionPolicy()
    {
        return $this->belongsTo(DeductionPolicy::class, 'deduction_policy', 'id_deduction_policy');
    }

}