<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffAllowance extends Model
{
    protected $table = 'staff_allowance';
    protected $primaryKey = 'id_staff_allowance';
    
    protected $fillable = [
        'staff_id',
        'allowance_id',
        'allowance_amount',
        'staff_allowance_status',
        'created_by',
        'cancelled_by',
        'cancelled_on'
    ];
    
    protected $dates = ['created_on', 'cancelled_on'];
    
    public $timestamps = false;
    
    // Relationships
    public function staff()
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id_staff');
    }
    
    public function allowance()
    {
        return $this->belongsTo(Allowance::class, 'allowance_id', 'id_allowances');
    }
}