<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StaffLeave extends Model
{
    use HasFactory;

    protected $table = 'staff_leaves';
    protected $primaryKey = 'id_staff_leaves';

    protected $fillable = [
        'staff_id',
        'staff_leave_date',
        'leave_type',
        'leave_reason',
        'staff_leave_status',
        'created_by',
        'created_on',
    ];

    protected $casts = [
        'staff_leave_date' => 'date',
        'created_on' => 'datetime',
    ];

    // Relationships
    public function staff()
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id_staff');
    }

    // Track leaves by staff_id and leave_type (no leave_application_id foreign key)
    public function leaveApplications()
    {
        return $this->hasMany(LeaveApplication::class, 'staff_id', 'staff_id')
                    ->where('leave_type', $this->leave_type);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('staff_leave_status', 'Active');
    }

    public function scopeByStaff($query, $staffId)
    {
        return $query->where('staff_id', $staffId);
    }

    public function scopeByYear($query, $year)
    {
        return $query->whereYear('staff_leave_date', $year);
    }

    public function scopeByLeaveType($query, $leaveType)
    {
        return $query->where('leave_type', $leaveType);
    }

    public function scopeByDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('staff_leave_date', [$startDate, $endDate]);
    }
}