<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Stores extends Model
{
    use HasApiTokens, HasFactory, Notifiable;
    
    protected $table = 'business_stores'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_business_stores';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'business_store',
        'store_address',
        'store_city',
        'store_cell',
        'store_phone1',
        'store_manager',
        'created_by',
        'created_on',
        'account_head_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); 
    }

    public function batches()
    {
        return $this->hasMany(ProductBatch::class, 'store_id', 'id_business_stores'); 
    }

}
