<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class NotValid extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'business_supplier'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_business_supplier'; // <-- this tells Laravel to use the correct primary key

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [

        'business_id',
        'supplier_name',
        'contact_person',
        'contact_number',
        'office_phone1',
        'office_phone2',
        'website',
        'ho_address',
        'email'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

}
