<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class TransferNotes extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'transfer_notes'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_transfer_notes';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'business_id',
          'gtn_id',
          'product_id',
          'tranfer_out_qty',
          'tranfer_in_qty',
          'unit_type',
          'transfer_date',
          'created_by',
          'status',
          'batch',
          'batch_id',
          'requisition_id',
          'updated_at',
          'created_at'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

}