<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;


    protected $primaryKey = 'id_users';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'user_name',        
        'user_password',
        'user_firstname',
        'user_lastname',
        'user_fullname',
        'user_email',
        'user_mobile',
        'user_phone',
        'user_address',
        'user_image',
        'user_status',
        'user_hidden',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'user_password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        //'user_password' => 'md5',
    ];


   

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of business table is `id_business`
    }


    /**
     * Legacy roles relationship - kept for backward compatibility
     */
    // public function roles()
    // {
    //     return $this->belongsToMany(Role::class, 'user_roles', 'user_id', 'role_id')
    //                 ->using(UserRole::class)
    //                 ->withPivot('id_user_roles'); // optional, only if you need it
    // }

    /**
     * Get the legacy role name from the old system
     * 
     * @return string|null
     */
    public function getLegacyRoleName(): ?string
    {
        $legacyRole = $this->roles()->first();
        return $legacyRole ? $legacyRole->name : null;
    }

    /**
     * Check if user has a Spatie role
     * 
     * @param string $roleName
     * @return bool
     */
    public function hasSpatieRole(string $roleName): bool
    {
        return $this->hasRole($roleName);
    }

    /**
     * Sync user's legacy role to Spatie
     * This method syncs the role from the legacy system to Spatie's permission system
     * 
     * @return void
     */
    public function syncToSpatie(): void
    {
        $legacyRole = $this->roles()->first();
        if ($legacyRole && $legacyRole->name) {
            // Use the RoleSyncService to sync
            app(\App\Services\RoleSyncService::class)->syncUserRolesToSpatie($this);
        }
    }
}