<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;

class UserRole extends Pivot
{
    protected $table = 'user_roles';
    protected $primaryKey = 'id_user_roles'; // Only needed if your pivot table has a PK

    public $incrementing = true; // Set to false if your pivot table doesn't auto-increment
    public $timestamps = false;  // Usually pivot tables don't have timestamps

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id_users');
    }

    public function role()
    {
        return $this->belongsTo(Role::class, 'id', 'id_roles');
    }
}
