<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class VisitAdvance extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'visit_advance'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_visit_advance';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'customer_visit_id',
        'advance_amount',
        'advance_date',
        'advance_mode',
        'advance_inst',
        'advance_remarks',
        'advance_user',
        'advance_cc_charge',
        'updated_at',
        'created_at',
        'cancelled_by',
        'cancelled_on',
        'advance_status',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function customer_visits()
    {
        return $this->belongsTo(CustomerVisits::class, 'customer_visit_id', 'id_customer_visits'); // assuming PK of customer_visits table is `id_customer_visits`
    }


}
