<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class VisitServiceStaff extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'visit_service_staffs'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_visit_service_staffs';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       
       'customer_visit_id',
        'visit_service_id',
        'staff_id',
        'staff_name',
        'visit_service_staff_status',
        'business_id',
        'additional_staff',
        'requested',
        'block_other'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function visit_services()
    {
        return $this->belongsTo(VisitServices::class, 'visit_service_id', 'id_visit_services'); // assuming PK of visit_service table is `id_visit_services`
    }

    public function customer_visits()
    {
        return $this->belongsTo(CustomerVisits::class, 'customer_visit_id', 'id_customer_visits'); // assuming PK of customer_visits table is `id_customer_visits`
    }


}
