<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class VisitServices extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'visit_services'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_visit_services';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       "business_id",
       'customer_visit_id',
       'service_id',
       'service_name',
       'visit_service_start',
       'visit_service_end',
       'update_date',
       'service_flag',
       'id_service_category',       
       'loyalty_service',
       'promo',
       'membership',
       'visit_service_status',
       'id_service_type',
       's_type',
       's_category',
       's_rate',
       'checkin',
       'crosssell',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
    ];


    public function customer_visits()
    {
        return $this->belongsTo(CustomerVisits::class, 'customer_visit_id', 'id_customer_visits'); // assuming PK of customer_visits table is `id_customer_visits`
    }


}
