<?php

namespace App\Observers;

use App\Models\UserRole;
use App\Services\RoleSyncService;

class UserRoleObserver
{
    protected $syncService;

    /**
     * Create the observer instance.
     */
    public function __construct(RoleSyncService $syncService)
    {
        $this->syncService = $syncService;
    }

    /**
     * Handle the UserRole "created" event.
     */
    public function created(UserRole $userRole): void
    {
        // user_id in pivot table maps to id_users in users table
        $user = \App\Models\User::where('id_users', $userRole->user_id)->first();
        if ($user) {
            $this->syncService->syncUserRolesToSpatie($user);
        }
    }

    /**
     * Handle the UserRole "deleted" event.
     */
    public function deleted(UserRole $userRole): void
    {
        // user_id in pivot table maps to id_users in users table
        $user = \App\Models\User::where('id_users', $userRole->user_id)->first();
        if ($user) {
            $this->syncService->syncUserRolesToSpatie($user);
        }
    }
}
