<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\MenuService;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $menuService = app(MenuService::class);

        view()->composer(
            [
                'layouts.settings',
                'layouts.horizontal',
                'layouts.vertical',
            ],
        function ($view) use ($menuService) {
                $menus = $menuService->getMenus([
                    'is_active' => true
                ]);
                $view->with('menus', $menus);
                // Also provide searchable menu items for navbar search
                // This ensures search only shows items the user has permission to see
                $view->with('searchableMenuItems', $menuService->getSearchableMenuItems($menus));
            }
        );
    }
}