<?php

namespace App\Services;

use App\Models\Staff;
use App\Models\Franchise;
use App\Models\Supplier;
use App\Models\Business;
use Illuminate\Support\Facades\DB;

class FiltersService
{
    /**
     * Filter: Staff
     */
    public function getStaff($business_id = 0)
    {
        $staff = Staff::select(
                'staff.id_staff as id',
                'staff_fullname as text',
                'staff_cell',
                'staff_email',
                'staff.business_id',
                'staff_image',
                DB::raw('CASE WHEN staff.staff_active = "y" THEN "Active" ELSE "Inactive" END as staff_type'),
                'business.business_name'
            )
            ->join('business', 'staff.business_id', '=', 'business.id_business');

        if ($business_id != 0) {
            $staff->where('staff.business_id', $business_id);
        }else {
            $staff->where(function ($query) {
                $query->where('business.ho_accounts', '=', "Yes")->orwhere('ho','Yes');
            });
        }

        return $staff->get();
    }

    /**
     * Filter: Franchises
     */
    public function getFranchises($business_id = 0)
    {
        $franchises = Franchise::select(
                'id_franchises as id',
                'business.business_name',
                'franchises.business_id',
                'franchises.franchise_name as text',
                'franchises.franchise_name as franchise_name',
                'franchises.franchise_contact as contact_person',
                'franchises.franchise_email as email',
                'franchises.franchise_office_phone as franchise_office_phone',
                'franchises.franchise_address as address',
                'franchises.franchise_owner as owner',
                'franchises.franchise_status'
            )
            ->join('business', 'business.id_business', '=', 'franchises.business_id');

        if ($business_id != 0) {
            $franchises->where('franchises.business_id', $business_id);
        }else {
            $franchises->whereIn('franchises.business_id', function ($query) {
                $query->where('business.ho_accounts', '=', "Yes")->orwhere('ho','Yes'); 
            });
        }
        return $franchises->get();
    }

    /**
     * Filter: Suppliers
     */
    public function getSuppliers($business_id = 0)
    {
        $suppliers = Supplier::select(
                'id_business_supplier as id',
                'business.business_name',
                'business_supplier.business_id',
                'business_supplier.supplier_name as text',
                'business_supplier.supplier_name as supplier_name',
                'business_supplier.contact_person as contact_person',
                'business_supplier.email as email',
                'business_supplier.contact_number as supplier_cell',
                DB::raw('"Yes" as supplier_active')
            )
            ->join('business', 'business.id_business', '=', 'business_supplier.business_id');

        if ($business_id != 0) {
            $suppliers->where('business_supplier.business_id', $business_id);
        }else {
             $suppliers->whereIn('business_supplier.business_id', function ($query) {
             $query->where('business.ho_accounts', '=', "Yes")->orwhere('ho','Yes');
            });
        }
        return $suppliers->get();
    }
    /**
     * Filter: Business list
     */
    public function getBusinesses()
    {
        return Business::select(
                'id_business as id',
                'business_name as text',
                'business_logo',
                'business_type_id',
                'business_address',
                'business_phone1',
                'business_email',
                'common_products',
                'common_services',
                'ho'
            )
            ->get(); 
    }
}
