<?php

namespace App\Services;
use App\Models\SMSCred;
use App\Models\SMSLog;
use App\Models\Invoice;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Exception;
use App\Models\Business;
class ProductsStockService
{
    
    public function __construct()
    {
        
    }

    public function gettingProductsStock($store_id = 0, $businessId = 0) {
        try {

            $storeId = $store_id;

            $query = DB::table('business_products')
                ->selectRaw("
                    business.id_business,
                    business.business_name,
                    business_products.id_business_products,
                    CASE 
                        WHEN business_products.professional = 'y' 
                            THEN 'Professional'
                        ELSE 'Retail'
                    END AS is_professional,
                    business_products.category,
                    business_products.product,
                    business_brands.business_brand_name,
                    business_stores.id_business_stores,
                    business_stores.business_store,
                    business_products.measure_unit,
                    business_products.qty_per_unit,
                    business_products.unit_type,
                    product_batch.id_batch,
                    product_batch.batch_number,
                    product_batch.batch_date,
                    SUM(IFNULL(adj.addition, 0)) as addition_qty,
                    SUM(IFNULL(f.qty_purchased, 0)) as purchased_qty,
                    SUM(IFNULL(g.transfer_in, 0)) as transfer_in_qty,
                    SUM(IFNULL(g.transfer_out, 0)) as transfer_out_qty,
                    SUM(IFNULL(a.sold, 0)) + SUM(IFNULL(h.franchise_sale, 0)) as sold_qty,
                    SUM(IFNULL(b.used, 0)) as used_qty,
                    SUM(IFNULL(c.returned, 0)) as returned_qty,
                    SUM(IFNULL(h.franchise_sale, 0)) as franchise_sale_qty,
                    SUM(
                        (IFNULL(adj.addition,0) + IFNULL(f.qty_purchased,0) + IFNULL(g.transfer_in,0))
                        - (IFNULL(g.transfer_out,0) + IFNULL(a.sold,0) + IFNULL(b.used,0) + IFNULL(c.returned,0) + IFNULL(h.franchise_sale,0))
                    ) as instock,
                    
                    
                    SUM(
                        ((IFNULL(adj.addition,0) + IFNULL(f.qty_purchased,0) + IFNULL(g.transfer_in,0))
                        - (IFNULL(g.transfer_out,0) + IFNULL(a.sold,0) + IFNULL(b.used,0) + IFNULL(c.returned,0) + IFNULL(h.franchise_sale,0)))
                        * ROUND(product_batch.batch_amount, 2)
                    ) as total_value_raw
                ")
                ->join('business_brands', 'business_brands.id_business_brands', '=', 'business_products.brand_id')
                ->join('product_batch', 'product_batch.product_id', '=', 'business_products.id_business_products')
                ->join('business_stores', 'business_stores.id_business_stores', '=', 'product_batch.store_id')
                ->join('business', 'business.id_business', '=', 'business_stores.business_id')
                ->leftJoin(DB::raw("(
                    SELECT batch_id, product_id, SUM(IFNULL(adjustment_qty,0)) as addition
                    FROM adjustment_notes
                    GROUP BY batch_id, product_id
                ) as adj"), function($join) {
                    $join->on('adj.product_id', '=', 'business_products.id_business_products')
                        ->on('adj.batch_id', '=', 'product_batch.id_batch');
                })
                ->leftJoin(DB::raw("(
                    SELECT batch_id, product_batch.product_id, SUM(invoice_qty) as sold
                    FROM invoice_products
                    JOIN invoice ON invoice.id_invoice = invoice_products.invoice_id
                    JOIN product_batch ON product_batch.id_batch = invoice_products.batch_id
                    WHERE invoice_status = 'valid'
                    AND IFNULL(reference_invoice_number,'') = ''
                    AND batch_id IS NOT NULL
                    AND IFNULL(batch_id,0) != 0
                    GROUP BY batch_id, product_id
                ) as a"), function($join) {
                    $join->on('a.product_id', '=', 'business_products.id_business_products')
                        ->on('a.batch_id', '=', 'product_batch.id_batch');
                })
                ->leftJoin(DB::raw("(
                    SELECT product_id, batch, batch_id, SUM(IFNULL(dispatch_qty,0)) as used
                    FROM dispatch_notes
                    WHERE status = 'Active'
                    AND IFNULL(batch_id,0) != 0
                    GROUP BY product_id, batch, batch_id
                ) as b"), function($join) {
                    $join->on('b.product_id', '=', 'business_products.id_business_products')
                        ->on('b.batch_id', '=', 'product_batch.id_batch');
                })
                ->leftJoin(DB::raw("(
                    SELECT product_id, batch_id, SUM(IFNULL(return_qty,0)) as returned
                    FROM return_notes
                    WHERE return_status = 'Active'
                    AND IFNULL(batch_id,0) != 0
                    GROUP BY product_id, batch_id
                ) as c"), function($join) {
                    $join->on('c.product_id', '=', 'business_products.id_business_products')
                        ->on('c.batch_id', '=', 'product_batch.id_batch');
                })
                ->leftJoin(DB::raw("(
                    SELECT grn_product_id, grn_batch_id, SUM(IFNULL(grn_qty_received,0)) as qty_purchased
                    FROM grn_details
                    JOIN goods_received_note ON goods_received_note.grn_id = grn_details.grn_id
                    WHERE grn_batch_id IS NOT NULL
                    GROUP BY grn_product_id, grn_batch_id
                ) as f"), function($join) {
                    $join->on('f.grn_product_id', '=', 'business_products.id_business_products')
                        ->on('f.grn_batch_id', '=', 'product_batch.id_batch');
                })
                ->leftJoin(DB::raw("(
                    SELECT product_id, batch_id,
                        SUM(IFNULL(tranfer_out_qty,0)) as transfer_out,
                        SUM(IFNULL(tranfer_in_qty,0)) as transfer_in
                    FROM transfer_notes
                    WHERE batch_id IS NOT NULL
                    AND transfer_notes.status='Active'
                    GROUP BY product_id, batch_id
                ) as g"), function($join) {
                    $join->on('g.product_id', '=', 'business_products.id_business_products')
                        ->on('g.batch_id', '=', 'product_batch.id_batch');
                })
                ->leftJoin(DB::raw("(
                    SELECT product_id, batch_id, SUM(IFNULL(qty,0)) as franchise_sale
                    FROM franchise_order_products
                    JOIN franchise_orders ON franchise_orders.id_franchise_orders = franchise_order_id
                    WHERE batch_id IS NOT NULL
                    AND (franchise_orders.order_status='Paid' OR franchise_orders.order_status='Invoiced')
                    GROUP BY product_id, batch_id
                ) as h"), function($join) {
                    $join->on('h.product_id', '=', 'business_products.id_business_products')
                        ->on('h.batch_id', '=', 'product_batch.id_batch');
                })
                ->where('business_product_active', 'Yes');

            //--------------- Filters START ---------------
            if(session('common_products') === 'No') {
                $query->where('business_products.business_id', session('business_id'));
            } else {
                $business_ids = Business::where('common_products', 'Yes')->pluck('id_business')->toArray();
                $query->whereIn('business_products.business_id', $business_ids);
            }

            if (!empty($storeId) && $storeId > 0) {
                $query->where('business_stores.id_business_stores', $storeId);
            }

            if (!empty($businessId) && $businessId > 0) {
                $query->where('business_stores.business_id', $businessId);
            }
            //--------------- Filters END ---------------

            $query->groupBy(
                'business.id_business',          
                'business_stores.id_business_stores',
                'business_products.id_business_products' ,
                'product_batch.id_batch' 
            );
            // $query->havingRaw("
            //     SUM(
            //         (IFNULL(adj.addition,0) + IFNULL(f.qty_purchased,0) + IFNULL(g.transfer_in,0))
            //         - (IFNULL(g.transfer_out,0) + IFNULL(a.sold,0) + IFNULL(b.used,0) + IFNULL(c.returned,0) + IFNULL(h.franchise_sale,0))
            //     ) > 0
            // ");
            // $query->orderBy('business_products.brand_id')
            //         ->orderBy('business_products.product')
            //         ->orderBy('business_products.category')
            //         ->orderBy('expiry_date');
            $query->orderBy('business.id_business')
                  ->orderBy('business_stores.id_business_stores')
                  ->orderBy('business_products.id_business_products')
                  ->orderBy('business_products.category')
                  ->orderBy('expiry_date');

            $results = $query->get();

            $products_stock_data = $results->map(function ($item) {
                
                $average_batch_unit_amount = ($item->instock > 0 && $item->total_value_raw > 0) 
                    ? round($item->total_value_raw / $item->instock, 2)
                    : 0;

                return [
                    'business_id' => $item->id_business,
                    'business_name' => $item->business_name,
                    'batch_id' => $item->id_batch,
                    'batch_number' => $item->batch_number,
                    'batch_date' => $item->batch_date,
                    'product_id' => $item->id_business_products,
                    'is_professional' => $item->is_professional,
                    'product' => $item->product,
                    'category' => $item->category,
                    'business_brand_name' => $item->business_brand_name,
                    'store' => $item->business_store,
                    'store_id' => $item->id_business_stores,
                    'addition_qty' => (float) $item->addition_qty,
                    'purchased_qty' => (float) $item->purchased_qty,
                    'transfer_in_qty' => (float) $item->transfer_in_qty,
                    'transfer_out_qty' => (float) $item->transfer_out_qty,
                    'sold_qty' => (float) $item->sold_qty,
                    'used_qty' => (float) $item->used_qty,
                    'returned_qty' => (float) $item->returned_qty,
                    'franchise_sale_qty' => (float) $item->franchise_sale_qty,
                    'instock' => (float) $item->instock,
                    'average_batch_unit_price' => $average_batch_unit_amount,
                    'total_value' => round((float) $item->total_value_raw, 2),
                    'measure_unit' => $item->measure_unit,
                    'qty_per_unit' => $item->qty_per_unit,
                    'unit_type' => $item->unit_type,
                ];
            });
            
            return $products_stock_data;
        } catch (Exception $e) {
            Log::error('Error fetching product Stock: ' . $e->getMessage());
            return collect();
        }
    }


    public function getInvoiceSaleAndFranchiseSaleQty($store_id = 0, $businessId = 0, $from ='', $to ='') {
        try {
            $storeId = $store_id;

            $query = DB::table('business_products')
                ->selectRaw("
                    business_products.id_business_products,
                    business_products.product,
                    business_products.category,
                    business_brands.business_brand_name,
                    business_stores.id_business_stores,
                    business_stores.business_store,
                    
                    SUM(IFNULL(a.sold, 0)) as sold_qty,
                    SUM(IFNULL(h.franchise_sale, 0)) as franchise_sale_qty
                ")
                ->join('business_brands', 'business_brands.id_business_brands', '=', 'business_products.brand_id')
                ->join('product_batch', 'product_batch.product_id', '=', 'business_products.id_business_products')
                ->join('business_stores', 'business_stores.id_business_stores', '=', 'product_batch.store_id')
                
                // Sold quantities
                ->leftJoin(DB::raw("
                    (
                        SELECT batch_id, product_batch.product_id, SUM(invoice_qty) as sold
                        FROM invoice_products
                        JOIN invoice ON invoice.id_invoice = invoice_products.invoice_id
                        JOIN product_batch ON product_batch.id_batch = invoice_products.batch_id
                        WHERE invoice_status = 'valid'
                        AND IFNULL(reference_invoice_number,'') = ''
                        AND batch_id IS NOT NULL 
                        AND DATE(invoice_date) BETWEEN '$from' AND '$to'
                        AND IFNULL(batch_id,0) != 0
                        GROUP BY batch_id, product_id
                    ) as a
                "), function($join) {
                    $join->on('a.product_id', '=', 'business_products.id_business_products')
                        ->on('a.batch_id', '=', 'product_batch.id_batch');
                })

                // Franchise sale quantities
                ->leftJoin(DB::raw("
                    (
                        SELECT product_id, batch_id, SUM(IFNULL(qty,0)) as franchise_sale
                        FROM franchise_order_products
                        JOIN franchise_orders ON franchise_orders.id_franchise_orders = franchise_order_id
                        WHERE batch_id IS NOT NULL
                        AND (franchise_orders.order_status='Paid' OR franchise_orders.order_status='Invoiced')
                        AND DATE(franchise_orders.order_date) BETWEEN '$from' AND '$to'
                        GROUP BY product_id, batch_id
                    ) as h
                "), function($join) {
                    $join->on('h.product_id', '=', 'business_products.id_business_products')
                        ->on('h.batch_id', '=', 'product_batch.id_batch');
                })

                ->where('business_product_active', 'Yes');

            // Filters
            if (!empty($storeId) && $storeId > 0) {
                $query->where('business_stores.id_business_stores', $storeId);
            }

            if (!empty($businessId) && $businessId > 0) {
                $query->where('business_stores.business_id', $businessId);
            }

            $query->groupBy(
                'business_products.id_business_products',
                'business_stores.id_business_stores'
            )
            ->orderBy('business_products.product');

            $results = $query->get();

            // Map results to simple array
            $products_qty_data = $results->map(function ($item) {
                return [
                    'product_id' => $item->id_business_products,
                    'product' => $item->product,
                    'category' => $item->category,
                    'business_brand_name' => $item->business_brand_name,
                    'store' => $item->business_store,
                    'store_id' => $item->id_business_stores,
                    'sold_qty' => (float) $item->sold_qty,
                    'franchise_sale_qty' => (float) $item->franchise_sale_qty,
                ];
            });

            return $products_qty_data;

        } catch (Exception $e) {
            Log::error('Error fetching sold & franchise sale qty: ' . $e->getMessage());
            return collect();
        }
    }

    public function gettingProductsStockWithBF($store_id = 0, $businessId = 0, $from = '', $to = '')
    {
        try {

            /* ================= DATE CONDITIONS ================= */
            $dateAdj       = ($from && $to) ? " AND DATE(adjustment_date) BETWEEN '{$from}' AND '{$to}' " : "";
            $dateInvoice   = ($from && $to) ? " AND DATE(invoice_date) BETWEEN '{$from}' AND '{$to}' " : "";
            $dateDispatch  = ($from && $to) ? " AND DATE(dispatch_date) BETWEEN '{$from}' AND '{$to}' " : "";
            $dateReturn    = ($from && $to) ? " AND DATE(return_date) BETWEEN '{$from}' AND '{$to}' " : "";
            $dateGRN       = ($from && $to) ? " AND DATE(grn_created_date) BETWEEN '{$from}' AND '{$to}' " : "";
            $dateTransfer  = ($from && $to) ? " AND DATE(transfer_date) BETWEEN '{$from}' AND '{$to}' " : "";
            $dateFranchise = ($from && $to) ? " AND DATE(order_date) BETWEEN '{$from}' AND '{$to}' " : "";

            // BF (less than from date)
            $bfAdj       = $from ? " AND DATE(adjustment_date) < '{$from}' " : "";
            $bfInvoice   = $from ? " AND DATE(invoice_date) < '{$from}' " : "";
            $bfDispatch  = $from ? " AND DATE(dispatch_date) < '{$from}' " : "";
            $bfReturn    = $from ? " AND DATE(return_date) < '{$from}' " : "";
            $bfGRN       = $from ? " AND DATE(grn_created_date) < '{$from}' " : "";
            $bfTransfer  = $from ? " AND DATE(transfer_date) < '{$from}' " : "";
            $bfFranchise = $from ? " AND DATE(order_date) < '{$from}' " : "";

            /* ================= MAIN QUERY ================= */
            $query = DB::table('business_products')
                ->selectRaw("
                    business.id_business,
                    business.business_name,
                    business_products.id_business_products,
                    business_products.product,
                    CASE 
                        WHEN business_products.professional = 'y' 
                            THEN 'Professional'
                        ELSE 'Retail'
                    END AS is_professional,
                    business_products.category,
                    business_products.measure_unit,
                    business_products.qty_per_unit,
                    business_products.unit_type,
                    business_products.professional,
                    CASE 
                        WHEN business_products.professional = 'y' THEN 'Professional'
                        ELSE 'Retail'
                    END AS product_type,

                    business_brands.business_brand_name,

                    business_stores.id_business_stores,
                    business_stores.business_store,

                    IFNULL(SUM(bf.brought_forward_qty),0)   as brought_forward_qty,
                    IFNULL(SUM(bf.brought_forward_value),0) as brought_forward_value,

                    IFNULL(SUM(adj.addition),0)      as addition_qty,
                    IFNULL(SUM(f.qty_purchased),0)   as purchased_qty,
                    IFNULL(SUM(g.transfer_in),0)     as transfer_in_qty,
                    IFNULL(SUM(g.transfer_out),0)    as transfer_out_qty,
                    IFNULL(SUM(a.sold),0)            as sold_qty,
                    IFNULL(SUM(b.used),0)            as used_qty,
                    IFNULL(SUM(c.returned),0)        as returned_qty,
                    IFNULL(SUM(h.franchise_sale),0)  as franchise_sale_qty,

                    (
                        IFNULL(SUM(bf.brought_forward_qty),0)
                        + IFNULL(SUM(adj.addition),0)
                        + IFNULL(SUM(f.qty_purchased),0)
                        + IFNULL(SUM(g.transfer_in),0)
                        - IFNULL(SUM(g.transfer_out),0)
                        - IFNULL(SUM(a.sold),0)
                        - IFNULL(SUM(b.used),0)
                        - IFNULL(SUM(c.returned),0)
                        - IFNULL(SUM(h.franchise_sale),0)
                    ) as instock,
                    SUM(
                        (
                            IFNULL(bf.brought_forward_qty,0)
                            + IFNULL(adj.addition,0)
                            + IFNULL(f.qty_purchased,0)
                            + IFNULL(g.transfer_in,0)
                            - IFNULL(g.transfer_out,0)
                            - IFNULL(a.sold,0)
                            - IFNULL(b.used,0)
                            - IFNULL(c.returned,0)
                            - IFNULL(h.franchise_sale,0)
                        ) * product_batch.batch_amount
                    ) as total_value_raw
                ")
                ->join('business_brands','business_brands.id_business_brands','=','business_products.brand_id')
                ->join('product_batch','product_batch.product_id','=','business_products.id_business_products')
                ->join('business_stores','business_stores.id_business_stores','=','product_batch.store_id')
                ->join('business','business.id_business','=','business_stores.business_id');

            /* ================= BROUGHT FORWARD ================= */
            if ($from) {
                $query->leftJoin(DB::raw("
                    (
                        SELECT
                            pb.product_id,
                            pb.id_batch,
                            SUM(
                                IFNULL(adj.adj_qty,0)
                                + IFNULL(grn.grn_qty,0)
                                + IFNULL(ti.transfer_in,0)
                                - IFNULL(to1.transfer_out,0)
                                - IFNULL(inv.sold,0)
                                - IFNULL(disp.used,0)
                                - IFNULL(ret.returned,0)
                                - IFNULL(fr.franchise,0)
                            ) as brought_forward_qty,
                            SUM(
                                (
                                    IFNULL(adj.adj_qty,0)
                                    + IFNULL(grn.grn_qty,0)
                                    + IFNULL(ti.transfer_in,0)
                                    - IFNULL(to1.transfer_out,0)
                                    - IFNULL(inv.sold,0)
                                    - IFNULL(disp.used,0)
                                    - IFNULL(ret.returned,0)
                                    - IFNULL(fr.franchise,0)
                                ) * pb.batch_amount
                            ) as brought_forward_value
                        FROM product_batch pb

                        LEFT JOIN (
                            SELECT product_id,batch_id,SUM(adjustment_qty) adj_qty
                            FROM adjustment_notes WHERE 1=1 {$bfAdj}
                            GROUP BY product_id,batch_id
                        ) adj ON adj.product_id=pb.product_id AND adj.batch_id=pb.id_batch

                        LEFT JOIN (
                            SELECT grn_product_id,grn_batch_id,SUM(grn_qty_received) grn_qty
                            FROM grn_details
                            JOIN goods_received_note ON goods_received_note.grn_id=grn_details.grn_id
                            WHERE 1=1 {$bfGRN}
                            GROUP BY grn_product_id,grn_batch_id
                        ) grn ON grn.grn_product_id=pb.product_id AND grn.grn_batch_id=pb.id_batch

                        LEFT JOIN (
                            SELECT product_id,batch_id,SUM(tranfer_in_qty) transfer_in
                            FROM transfer_notes WHERE status='Active' {$bfTransfer}
                            GROUP BY product_id,batch_id
                        ) ti ON ti.product_id=pb.product_id AND ti.batch_id=pb.id_batch

                        LEFT JOIN (
                            SELECT product_id,batch_id,SUM(tranfer_out_qty) transfer_out
                            FROM transfer_notes WHERE status='Active' {$bfTransfer}
                            GROUP BY product_id,batch_id
                        ) to1 ON to1.product_id=pb.product_id AND to1.batch_id=pb.id_batch

                        LEFT JOIN (
                            SELECT product_id,batch_id,SUM(invoice_qty) sold
                            FROM invoice_products
                            JOIN invoice ON invoice.id_invoice=invoice_products.invoice_id
                            WHERE invoice_status='valid' 
                            AND IFNULL(reference_invoice_number,'') = ''
                            AND batch_id IS NOT NULL
                             {$bfInvoice}
                            GROUP BY product_id,batch_id
                        ) inv ON inv.product_id=pb.product_id AND inv.batch_id=pb.id_batch

                        LEFT JOIN (
                            SELECT product_id,batch_id,SUM(dispatch_qty) used
                            FROM dispatch_notes WHERE status='Active' {$bfDispatch}
                            GROUP BY product_id,batch_id
                        ) disp ON disp.product_id=pb.product_id AND disp.batch_id=pb.id_batch

                        LEFT JOIN (
                            SELECT product_id,batch_id,SUM(return_qty) returned
                            FROM return_notes WHERE return_status='Active' {$bfReturn}
                            GROUP BY product_id,batch_id
                        ) ret ON ret.product_id=pb.product_id AND ret.batch_id=pb.id_batch

                        LEFT JOIN (
                            SELECT product_id,batch_id,SUM(qty) franchise
                            FROM franchise_order_products
                            JOIN franchise_orders ON franchise_orders.id_franchise_orders=franchise_order_id
                            WHERE (order_status='Paid' OR order_status='Invoiced') {$bfFranchise}
                            GROUP BY product_id,batch_id
                        ) fr ON fr.product_id=pb.product_id AND fr.batch_id=pb.id_batch

                        GROUP BY pb.product_id,pb.id_batch
                    ) bf
                "), function ($join) {
                    $join->on('bf.product_id','=','business_products.id_business_products')
                        ->on('bf.id_batch','=','product_batch.id_batch');
                });
            }

            /* ================= CURRENT PERIOD JOINS ================= */

            // Adjustment
            $query->leftJoin(DB::raw("
                (SELECT product_id,batch_id,SUM(adjustment_qty) addition
                FROM adjustment_notes WHERE 1=1 {$dateAdj}
                GROUP BY product_id,batch_id) adj
            "), function ($join) {
                $join->on('adj.product_id','=','business_products.id_business_products')
                    ->on('adj.batch_id','=','product_batch.id_batch');
            });

            // Invoice
            $query->leftJoin(DB::raw("
                (SELECT product_id,batch_id,SUM(invoice_qty) sold
                FROM invoice_products
                JOIN invoice ON invoice.id_invoice=invoice_products.invoice_id
                WHERE invoice_status='valid'
                AND IFNULL(reference_invoice_number,'') = ''
                AND batch_id IS NOT NULL 
                {$dateInvoice}
                GROUP BY product_id,batch_id) a
            "), function ($join) {
                $join->on('a.product_id','=','business_products.id_business_products')
                    ->on('a.batch_id','=','product_batch.id_batch');
            });

            // Dispatch
            $query->leftJoin(DB::raw("
                (SELECT product_id,batch_id,SUM(dispatch_qty) used
                FROM dispatch_notes WHERE status='Active' {$dateDispatch}
                GROUP BY product_id,batch_id) b
            "), function ($join) {
                $join->on('b.product_id','=','business_products.id_business_products')
                    ->on('b.batch_id','=','product_batch.id_batch');
            });

            // Return
            $query->leftJoin(DB::raw("
                (SELECT product_id,batch_id,SUM(return_qty) returned
                FROM return_notes WHERE return_status='Active' {$dateReturn}
                GROUP BY product_id,batch_id) c
            "), function ($join) {
                $join->on('c.product_id','=','business_products.id_business_products')
                    ->on('c.batch_id','=','product_batch.id_batch');
            });

            // GRN
            $query->leftJoin(DB::raw("
                (SELECT grn_product_id,grn_batch_id,SUM(grn_qty_received) qty_purchased
                FROM grn_details
                JOIN goods_received_note ON goods_received_note.grn_id=grn_details.grn_id
                WHERE 1=1 {$dateGRN}
                GROUP BY grn_product_id,grn_batch_id) f
            "), function ($join) {
                $join->on('f.grn_product_id','=','business_products.id_business_products')
                    ->on('f.grn_batch_id','=','product_batch.id_batch');
            });

            // Transfer
            $query->leftJoin(DB::raw("
                (SELECT product_id,batch_id,
                        SUM(tranfer_in_qty) transfer_in,
                        SUM(tranfer_out_qty) transfer_out
                FROM transfer_notes
                WHERE status='Active' {$dateTransfer}
                GROUP BY product_id,batch_id) g
            "), function ($join) {
                $join->on('g.product_id','=','business_products.id_business_products')
                    ->on('g.batch_id','=','product_batch.id_batch');
            });

            // Franchise
            $query->leftJoin(DB::raw("
                (SELECT product_id,batch_id,SUM(qty) franchise_sale
                FROM franchise_order_products
                JOIN franchise_orders ON franchise_orders.id_franchise_orders=franchise_order_id
                WHERE (order_status='Paid' OR order_status='Invoiced') {$dateFranchise}
                GROUP BY product_id,batch_id) h
            "), function ($join) {
                $join->on('h.product_id','=','business_products.id_business_products')
                    ->on('h.batch_id','=','product_batch.id_batch');
            });

            /* ================= FILTERS ================= */
            $query->where('business_product_active','Yes');

            if ($store_id) {
                $query->where('business_stores.id_business_stores',$store_id);
            }

            if ($businessId) {
                $query->where('business_stores.business_id',$businessId);
            }

            /* ================= GROUP BY ================= */
            $query->groupBy(
                'business.id_business',
                'business_stores.id_business_stores',
                'business_products.id_business_products'
            );

            $query->orderBy('business.id_business', 'ASC')
            ->orderBy('business_stores.id_business_stores', 'ASC')
            ->orderBy('business_products.id_business_products', 'ASC');


            /* ================= EXECUTE ================= */
            $results = $query->get();
        //  return    $results = $query->toRawSql();

            /* ================= RESULT MAPPING ================= */
            $products_stock_data = $results->map(function ($item) {

                $instock = (float) $item->instock;
                $totalValueRaw = (float) $item->total_value_raw;

                $average_batch_unit_amount = ($instock > 0 && $totalValueRaw > 0)
                    ? round($totalValueRaw / $instock, 2)
                    : 0;

                return [
                    'branch' => $item->business_name,
                    'store' => $item->business_store,
                    'brand' => $item->business_brand_name,
                    'product_id' =>$item->id_business_products,
                    'product' => $item->product,
                    'pro' => $item->is_professional,
                    'category' => $item->category,
                    'product_type' => $item->product_type,
                    'unit_type' => $item->unit_type,
                    'qty_per_unit' => (float) $item->qty_per_unit,
                    'measure_unit' => $item->measure_unit,
                    'B/F Qty'   => (float) $item->brought_forward_qty,
                    // 'brought_forward_value' => round((float) $item->brought_forward_value, 2),
                    'manual_qty' => (float) $item->addition_qty,
                    'purchased_qty' => (float) $item->purchased_qty,
                    'transfer_in_qty' => (float) $item->transfer_in_qty,
                    'transfer_out_qty' => (float) $item->transfer_out_qty,
                    'sold_qty' => ((float) $item->sold_qty) + ((float) $item->franchise_sale_qty),
                    'used_qty' => ((float) $item->used_qty),
                    'returned_qty' => (float) $item->returned_qty,
                    'instock' => $instock,
                    'average_price' => $average_batch_unit_amount,
                    'total_value' => round($totalValueRaw, 2),
                    // 'franchise_sale_qty' => (float) $item->franchise_sale_qty,
                ];
            });
            return $products_stock_data;
        } catch (\Exception $e) {
            Log::error('Stock Report Error: '.$e->getMessage());
            return collect();
        }
    }
    
}    