<?php

namespace App\Services;
use App\Models\Customers;
use App\Models\AccountEventMapping;
use App\Models\AccountVoucherDetail;
use App\Models\Invoice;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Exception;

class customerDetailsService
{
    

    public function __construct()
    {
        
    }

    /**
     * Customer search params
     * @param int $customer_id
     * @param int $business_id
     * @return mixed
     * @throws Exception
     */

    public function getCustomerDetails($customer_id){
        try {
            $customerDetails = DB::table('customers')
                ->select(
                    'id_customers',
                    'customer_name',
                    'customer_email',
                    'customer_phone',
                    'customer_address',
                    'customer_type',
                    'customer_created_on',
                )
                ->where('id_customers', $customer_id)
                ->first();
            return $customerDetails;
        } catch (Exception $e) {
            Log::error("Error fetching customer details: " . $e->getMessage());
            throw new Exception("Error fetching customer details");
        }
    }

    public function getCustomerLoyaltyPoints($customer_id){
        try {
            $loyaltyPoints = $customer = Customers::select('id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_area', 
                DB::RAW('COALESCE(customers.customer_address, "") as customer_address'), 'customers.customer_email',
                DB::RAW('CASE WHEN sum(loyalty_earned) - sum(loyalty_used)  > 0 THEN round(sum(loyalty_earned) - sum(loyalty_used)) ELSE 0 END  as loyalty_points')
                )
                ->leftJoin('invoice', function($join){ 
                    $join->on('invoice.customer_id', '=', 'customers.id_customers')
                    ->where('invoice.invoice_status', '=', 'valid');
                })
                ->where('id_customers', '=', $customer_id)
                ->groupby('id_customers');

            return $loyaltyPoints;
        } catch (Exception $e) {
            return $e;
            Log::error("Error fetching customer loyalty points: " . $e->getMessage());
            throw new Exception("Error fetching customer loyalty points");
        }
    }

    public function getCustomerRetainedAmount($customer_id, $business_id){
        try {
            $retained_amount = "0";

            $business_id_for_account_head = session('ho_accounts') == 'Yes' ? DB::table('business')->where('ho', 'yes')->value('id_business'): session('business_id');
            
            //Get retained amount
            $account_head = AccountEventMapping::select('id_account_event_mapping', 'account_event_id', 'account_head_id', 'account_head')
            ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
            ->where('account_event_mapping.business_id', '=', $business_id_for_account_head)
            ->where('account_heads.business_id', '=', $business_id_for_account_head)
            ->where('entity_name', '=', 'retained_amount')
            ->where('account_event_id', '=', '1')
            ->first();

            $retained_account = $account_head->account_head_id ?? 0;
            if(null != $retained_account && $retained_account > 0){
                $query = AccountVoucherDetail::select('account_head_id', DB::RAW('sum(credit) - sum(debit) as retained_amount'))
                ->join('account_vouchers', 'account_vouchers.id_account_vouchers', '=', 'account_voucher_detail.account_voucher_id')
                ->where('account_head_id', '=', $retained_account)
                ->where('account_vouchers.business_partner_id', '=', $customer_id)
                ->where('account_vouchers.business_id', $business_id)
                ->groupby('account_head_id')
                ->first();

                //print_r($query->toSql()); exit();
                if($query){
                    $retained_amount = $query->retained_amount;
                }else{
                    $retained_amount = "0";    
                }

            } else {
                $retained_amount = "0";
            }

            return $retained_amount;
        } catch (Exception $e) {
            Log::error("Error fetching customer retained amount: " . $e->getMessage());
            throw new Exception("Error fetching customer retained amount");
        }
    }

    public function getCustomerBalanceInvoices($customer_id){
        try {
            $balance_invoices = Invoice::select(
                    'id_invoice',
                    'invoice_number',
                    'invoice_date',
                    DB::RAW('ROUND(balance, 2) as balance'),
                    DB::RAW('ROUND(paid_earlier, 2) as paid_earlier'),
                    DB::RAW('ROUND(total_payable, 2) as total_payable'),

                )
                ->where('customer_id', $customer_id)
                ->where('is_recovery', "Yes")
                ->where('invoice_status', 'valid')
                ->where('balance', '>', 0)
                ->get();

            return $balance_invoices;
        } catch (Exception $e) {
            Log::error("Error fetching customer balance invoices: " . $e->getMessage());
            throw new Exception("Error fetching customer balance invoices");
        }
    }

}