<?php

namespace App\Services;
use App\Models\DispatchRequest;
use App\Models\Dispatch;
use App\Models\Service;
use App\Models\CustomerVisits;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Exception;

class dispatchRequestService
{
    
    public function __construct()
    {
        
    }

    /**
     * Dispatch Request search params
     *
     * @param int $product_id
     * @param int $customer_id
     * @param int $visit_service_id
     * @param int $service_id
     * @param int $visit_id
     * @return mixed
     * @throws Exception
     */

    public function findExistingDispatchRequest($visit_service_id){
        try {
            $dispatchRequest = DispatchRequest::where('visit_service_id', $visit_service_id)                
                ->whereIn('dispatch_request_status', ['Active', 'Dispatched'])
                ->first();

            return $dispatchRequest;
        } catch (Exception $e) {
            Log::error("Error fetching dispatch request: " . $e->getMessage());
            throw new Exception("Error fetching dispatch request");
        }
    }

    public function createDispatchRequest($visit_id){
        try {
            //get the visit service details
            $visitService = CustomerVisits::where('customer_visits.id_customer_visits', $visit_id)
                ->join('visit_services', function($join) {
                    $join->on('visit_services.customer_visit_id', '=', 'customer_visits.id_customer_visits')
                    ->where('visit_services.visit_service_status', '=', 'Active');
                })
                ->join('visit_service_staffs', function($join){
                    $join->on('visit_service_staffs.visit_service_id', '=', 'visit_services.id_visit_services')
                    ->where('visit_service_staffs.visit_service_staff_status', '=', 'Active')
                    ->where('visit_service_staffs.additional_staff', '=', 'No');
                })
                ->join('services_products', function($join){
                    $join->on('services_products.business_service_id', '=', 'visit_services.service_id')
                    ->where('services_products.status', '=', 'Y');
                })
                ->join('business_products', 'business_products.id_business_products', '=', 'services_products.business_product_id')
                ->select(
                    'visit_services.id_visit_services as visit_service_id',
                    'visit_services.service_id',
                    DB::RAW('date_format(visit_services.visit_service_start, "%Y-%m-%d %h:%i:%s") as visit_service_start'),
                    'visit_service_staffs.id_visit_service_staffs as visit_service_staff_id',
                    'customer_visits.customer_id',
                    'customer_visits.id_customer_visits as customer_visit_id',
                    'services_products.business_product_id',
                    'services_products.usage_qty',
                    'business_products.product',
                    'business_products.unit_type',
                    'business_products.measure_unit',
                    'business_products.qty_per_unit'
                )
                ->get();
            if($visitService->isEmpty()){
                Log::error("Dispatch Request : No active visit service found for visit ID: " . $visit_id);
                //all dispatch requests created successfully
                return response()->json([
                    'success' => true,
                    'message_type' => 'info',
                    'message' => 'No active visit service found for dispatch request creation.',
                    'message_button' => 'btn btn-info',
                    'request' => null
                ]);
            }

            foreach($visitService as $service){
                $dispatchRequest = DispatchRequest::where('visit_service_id', $service->visit_service_id)                
                ->whereIn('dispatch_request_status', ['Active', 'Dispatched'])
                ->first();
                if($dispatchRequest){                    
                    //continue; // Skip to next service if dispatch request already exists
                }
                
                $data = [
                    //'business_id' => session('business_id'),
                    'customer_visit_id' => $service->customer_visit_id,
                    'customer_id' => $service->customer_id,
                    'service_id' => $service->service_id,
                    'visit_service_id' => $service->visit_service_id,
                    'visit_service_staff_id' => $service->visit_service_staff_id,
                    'product_id' => $service->business_product_id,
                    'product_name' => $service->product,
                    'product_qty' => $service->usage_qty,
                    'product_unit' => $service->measure_unit,
                    'dispatch_request_date' => $service->visit_service_start,
                    'dispatch_request_status' => 'Active',
                    'created_on' => now(),
                    'created_by' => session('user_name'),
                ];

                $dispatchRequest = DispatchRequest::create($data);
            }
            return response()->json([
                'success'=>true,
                'message_type' => 'success',
                'message' => 'Dispatch request(s) created successfully.',
                'message_button' => 'btn btn-success',
                'request' => $dispatchRequest
            ]);
        } catch (Exception $e) {
            Log::error("Error creating dispatch request: " . $e->getMessage());
            //throw new Exception("Error creating dispatch request");
            return response()->json([
                'success'=>false,
                'message_type' => 'info',
                'message' => 'Error creating dispatch request: ' . $e->getMessage(),
                'message_button' => 'btn btn-danger',
                'request' => null
            ]);
        }
    }



}