<?php

namespace App\Services;
use App\Models\SMSCred;
use App\Models\SMSLog;
use App\Models\Invoice;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Exception;

class productBatchService
{
    
    public function __construct()
    {
        
    }

      /**
     * Batch search params
     *
     * @param int $product_id
     * @param int $store_id
     * @param int $business_id
     * @params int $batch_id
     * @return mixed
     * @throws Exception
     */
    public function findSufficientBatches($businessProductId, $businessId, $storeId, $batchId = null){
        try {
        // Build the query
        $query = DB::table('business_products')
            ->selectRaw("
                id_business_products, business_products.category, business_products.product, 
                business_brands.business_brand_name, measure_unit, qty_per_unit, product_batch.id_batch as id,
                IFNULL(business_products.category, '') as mcategory,
                product_batch.expiry_date,
                business_products.price,
                IFNULL(adj.addition, 0) as total,
                IFNULL(f.qty_purchased, 0) as purchased,
                IFNULL(g.transfer_in, 0) as transferin,
                IFNULL(g.transfer_out, 0) as transferout,
                IFNULL(a.sold, 0) + IFNULL(h.franchise_sale, 0) as sold,
                IFNULL(b.used, 0) as used,
                IFNULL(c.returned, 0) as returned,

                (IFNULL(adj.addition,0) + IFNULL(f.qty_purchased,0) + IFNULL(g.transfer_in,0))
                - (IFNULL(g.transfer_out,0) + IFNULL(a.sold,0) + IFNULL(b.used,0) + IFNULL(c.returned,0) + IFNULL(h.franchise_sale,0)) as instock,

                business_store, id_business_stores,
                batch_number as batch,
                batch_number,
                ROUND(product_batch.batch_amount, 2) as batch_amount,
                product_batch.id_batch as batch_id,
                IFNULL(unit_type,'') as unit_type,
                IFNULL(measure_unit,'') as measure_unit,
                IFNULL(qty_per_unit,'') as qty_per_unit,

                CONCAT(
                    id_business_products, ', ',
                    ((IFNULL(adj.addition,0) + IFNULL(f.qty_purchased,0) + IFNULL(g.transfer_in,0))
                    - (IFNULL(g.transfer_out,0) + IFNULL(a.sold,0) + IFNULL(b.used,0) + IFNULL(c.returned,0))),
                    ', ', product, ', ', IFNULL(category,''), ', ', IFNULL(batch_number,''), ', ',
                    IFNULL(id_batch,0), ', ', IFNULL(unit_type,''), ', ', IFNULL(measure_unit,''), ', ',
                    IFNULL(qty_per_unit,'')
                ) as id
            ")
            ->join('business_brands', 'business_brands.id_business_brands', '=', 'business_products.brand_id')
            ->join('product_batch', 'product_batch.product_id', '=', 'business_products.id_business_products')
            ->join('business_stores', 'business_stores.id_business_stores', '=', 'product_batch.store_id')
            ->leftJoin(DB::raw("(
                SELECT batch_id, product_id, SUM(IFNULL(adjustment_qty,0)) as addition
                FROM adjustment_notes
                GROUP BY batch_id, product_id
            ) as adj"), function($join) {
                $join->on('adj.product_id', '=', 'business_products.id_business_products')
                    ->on('adj.batch_id', '=', 'product_batch.id_batch');
            })
            ->leftJoin(DB::raw("(
                SELECT batch_id, product_batch.product_id, SUM(invoice_qty) as sold
                FROM invoice_products
                JOIN invoice ON invoice.id_invoice = invoice_products.invoice_id
                JOIN product_batch ON product_batch.id_batch = invoice_products.batch_id
                WHERE invoice_status = 'valid'
                AND reference_invoice_number = ''
                AND IFNULL(batch_id,0) != 0
                GROUP BY batch_id, product_id
            ) as a"), function($join) {
                $join->on('a.product_id', '=', 'business_products.id_business_products')
                    ->on('a.batch_id', '=', 'product_batch.id_batch');
            })
            ->leftJoin(DB::raw("(
                SELECT product_id, batch, batch_id, SUM(IFNULL(dispatch_qty,0)) as used
                FROM dispatch_notes
                WHERE status = 'Active'
                AND IFNULL(batch_id,0) != 0
                GROUP BY product_id, batch, batch_id
            ) as b"), function($join) {
                $join->on('b.product_id', '=', 'business_products.id_business_products')
                    ->on('b.batch_id', '=', 'product_batch.id_batch');
            })
            ->leftJoin(DB::raw("(
                SELECT product_id, batch_id, SUM(IFNULL(return_qty,0)) as returned
                FROM return_notes
                WHERE return_status = 'Active'
                AND IFNULL(batch_id,0) != 0
                GROUP BY product_id, batch_id
            ) as c"), function($join) {
                $join->on('c.product_id', '=', 'business_products.id_business_products')
                    ->on('c.batch_id', '=', 'product_batch.id_batch');
            })
            ->leftJoin(DB::raw("(
                SELECT grn_product_id, grn_batch_id, SUM(IFNULL(grn_qty_received,0)) as qty_purchased
                FROM grn_details
                JOIN goods_received_note ON goods_received_note.grn_id = grn_details.grn_id
                WHERE grn_batch_id IS NOT NULL
                GROUP BY grn_product_id, grn_batch_id
            ) as f"), function($join) {
                $join->on('f.grn_product_id', '=', 'business_products.id_business_products')
                    ->on('f.grn_batch_id', '=', 'product_batch.id_batch');
            })
            ->leftJoin(DB::raw("(
                SELECT product_id, batch_id,
                    SUM(IFNULL(tranfer_out_qty,0)) as transfer_out,
                    SUM(IFNULL(tranfer_in_qty,0)) as transfer_in
                FROM transfer_notes
                WHERE batch_id IS NOT NULL
                AND transfer_notes.status='Active'
                GROUP BY product_id, batch_id
            ) as g"), function($join) {
                $join->on('g.product_id', '=', 'business_products.id_business_products')
                    ->on('g.batch_id', '=', 'product_batch.id_batch');
            })
            ->leftJoin(DB::raw("(
                SELECT product_id, batch_id, SUM(IFNULL(qty,0)) as franchise_sale
                FROM franchise_order_products
                JOIN franchise_orders ON franchise_orders.id_franchise_orders = franchise_order_id
                WHERE batch_id IS NOT NULL
                AND (franchise_orders.order_status='Paid' OR franchise_orders.order_status='Invoiced')
                GROUP BY product_id, batch_id
            ) as h"), function($join) {
                $join->on('h.product_id', '=', 'business_products.id_business_products')
                    ->on('h.batch_id', '=', 'product_batch.id_batch');
            })
            ->where('business_product_active', 'Yes');

            if (!empty($storeId) && $storeId > 0) {
                $query->where('business_stores.id_business_stores', $storeId);
            }

            if (!empty($businessId) && $businessId > 0) {
                $query->where('business_stores.business_id', $businessId);
            }
            
            $query->whereRaw("
                (IFNULL(adj.addition,0) + IFNULL(f.qty_purchased,0) + IFNULL(g.transfer_in,0))
                - (IFNULL(g.transfer_out,0) + IFNULL(a.sold,0) + IFNULL(b.used,0) + IFNULL(c.returned,0) + IFNULL(h.franchise_sale,0)) > 0
            ");            

            $query->where('business_products.id_business_products', $businessProductId);
            
            if(!empty($batchId)){
                $query->where('product_batch.id_batch', $batchId);
            }

            $query->orderBy('business_products.brand_id')
                ->orderBy('business_products.product')
                ->orderBy('business_products.category')
                ->orderBy('expiry_date');

            $results = $query->get();
            $batches = $results->map(function($item) {
                return [
                    'id' => $item->id_business_products,
                    'product' => $item->product,
                    'category' => $item->category,
                    'business_brand_name' => $item->business_brand_name,
                    'expiry_date' => $item->expiry_date,
                    'batch_no' => $item->batch,
                    'batch_id' => $item->batch_id,
                    'batch_amount' => $item->batch_amount,
                    'store' => $item->business_store,
                    'store_id' => $item->id_business_stores,
                    'instock' => $item->instock,
                    'price' => $item->price,
                    'measure_unit' => $item->measure_unit,
                    'qty_per_unit' => $item->qty_per_unit,
                    'unit_type' => $item->unit_type,
                ];
            });

            Log::info('Fetched product batches: ' . $batches->count() . ' batches found for product ID ' . $businessProductId);
            return json_encode($batches);
        } catch (Exception $e) {
            Log::error('Error fetching product batches: ' . $e->getMessage());
            return collect(); // Return an empty collection on error
        }
    }
          
}