<?php

namespace Database\Factories;

use App\Models\BlockEvent;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\BlockEvent>
 */
class BlockEventFactory extends Factory
{
    protected $model = BlockEvent::class;

    public function definition(): array
    {
        return [
            'business_id' => Business::factory(),
            'block_event_name' => $this->faker->words(3, true),
            'block_event_desc' => $this->faker->sentence(),
            'block_event_duration' => '00:00:00',
        ];
    }
}
