<?php

namespace Database\Factories;

use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Business>
 */
class BusinessFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Business::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'business_name' => $this->faker->company(),
            'business_address' => $this->faker->address(),
            'business_area' => $this->faker->city(),
            'business_email' => $this->faker->companyEmail(),
            'business_phone1' => $this->faker->phoneNumber(),
            'business_owner' => $this->faker->name(),
            'business_owner_contact' => $this->faker->phoneNumber(),
            'business_opening_time' => '09:00:00',
            'business_closing_time' => '18:00:00',
            'common_products' => 'No',
            'common_services' => 'No',
        ];
    }
}
