<?php

namespace Database\Factories;

use App\Models\Customers;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Customers>
 */
class CustomersFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Customers::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'business_id' => Business::factory(),
            'customer_name' => $this->faker->name(),
            'customer_email' => $this->faker->unique()->safeEmail(),
            'customer_cell' => $this->faker->phoneNumber(),
            'customer_address' => $this->faker->address(),
            'customer_area' => $this->faker->city(),
            'customer_phone1' => $this->faker->phoneNumber(),
            'customer_type' => 'primary',
            'created_on' => now(),
            'loyalty_points' => 0,
            'customer_advance' => 0,
            'allowed_balance' => 0,
            // Required NOT NULL fields
            'customer_allergies' => '', // Empty string for NOT NULL field
            'customer_alert' => '', // Empty string for NOT NULL field
            'fcm_id' => '', // Empty string for NOT NULL field
        ];
    }
}
