<?php

namespace Database\Factories;

use App\Models\Department;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Department>
 */
class DepartmentFactory extends Factory
{
    protected $model = Department::class;

    public function definition(): array
    {
        return [
            'service_department' => $this->faker->words(2, true),
            'business_id' => Business::factory(),
            'department_status' => $this->faker->randomElement(['Active', 'InActive']),
        ];
    }
}
