<?php

namespace Database\Factories;

use App\Models\DiscountPassword;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DiscountPassword>
 */
class DiscountPasswordFactory extends Factory
{
    protected $model = DiscountPassword::class;

    public function definition(): array
    {
        return [
            'id' => $this->faker->unique()->numberBetween(1, 10000),
            'business_id' => Business::factory(),
            'name' => $this->faker->name(),
            'username' => $this->faker->unique()->userName(),
            'email' => $this->faker->unique()->safeEmail(),
            'password' => md5('password'), // MD5 hash as per system
            'created_on' => now(),
        ];
    }
}
