<?php

namespace Database\Factories;

use App\Models\DiscountReason;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DiscountReason>
 */
class DiscountReasonFactory extends Factory
{
    protected $model = DiscountReason::class;

    public function definition(): array
    {
        $type = $this->faker->randomElement(['Percentage', 'Fixed Amount']);
        $value = $type === 'Percentage' 
            ? $this->faker->numberBetween(5, 50) 
            : $this->faker->numberBetween(100, 1000);

        return [
            'discount_reason' => $this->faker->words(3, true),
            'business_id' => Business::factory(),
            'active' => $this->faker->randomElement(['Yes', 'No']),
            'discount_perc' => $type === 'Percentage' ? $value : 0,
            'fixed_amount' => $type === 'Fixed Amount' ? $value : 0,
        ];
    }
}
