<?php

namespace Database\Factories;

use App\Models\EyelashLength;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\EyelashLength>
 */
class EyelashLengthFactory extends Factory
{
    protected $model = EyelashLength::class;

    public function definition(): array
    {
        return [
            'length' => $this->faker->randomElement(['8mm', '10mm', '12mm', '14mm', '16mm']),
            'business_id' => Business::factory(),
        ];
    }
}
