<?php

namespace Database\Factories;

use App\Models\EyelashRecord;
use App\Models\Business;
use App\Models\Customers;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\EyelashRecord>
 */
class EyelashRecordFactory extends Factory
{
    protected $model = EyelashRecord::class;

    public function definition(): array
    {
        return [
            'eyelash_type' => $this->faker->word(),
            'business_id' => Business::factory(),
            'customer_id' => Customers::factory(),
            'customer_name' => $this->faker->name(),
            'thickness' => (string)$this->faker->randomFloat(2, 0.05, 0.25),
            'length' => $this->faker->randomElement(['8mm', '10mm', '12mm', '14mm']),
            'curl' => $this->faker->randomElement(['J', 'B', 'C', 'D']),
            'full_set_refill' => $this->faker->randomElement(['Full Set', 'Refill']),
            'date' => $this->faker->date(),
            'price' => (string)$this->faker->randomFloat(2, 500, 5000),
            'remarks' => $this->faker->sentence(),
            'visit_id' => null,
            'created_date' => now(),
        ];
    }
}
