<?php

namespace Database\Factories;

use App\Models\EyelashThickness;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\EyelashThickness>
 */
class EyelashThicknessFactory extends Factory
{
    protected $model = EyelashThickness::class;

    public function definition(): array
    {
        return [
            'thickness' => (string)$this->faker->randomFloat(2, 0.05, 0.25),
            'business_id' => Business::factory(),
        ];
    }
}
