<?php

namespace Database\Factories;

use App\Models\FacialRecord;
use App\Models\Business;
use App\Models\Customers;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\FacialRecord>
 */
class FacialRecordFactory extends Factory
{
    protected $model = FacialRecord::class;

    public function definition(): array
    {
        return [
            'business_id' => Business::factory(),
            'customer_id' => Customers::factory(),
            'customer' => $this->faker->name(),
            'facial' => $this->faker->words(2, true),
            'exfoliant' => $this->faker->words(2, true),
            'mask' => $this->faker->words(2, true),
            'cleanser' => $this->faker->words(2, true),
            'date' => $this->faker->date(),
            'time' => (string)$this->faker->numberBetween(30, 180), // minutes
            'charge' => (string)$this->faker->randomFloat(2, 100, 5000),
            'remarks' => $this->faker->sentence(),
            'visit_id' => null,
            'created_date' => now(),
        ];
    }
}
