<?php

namespace Database\Factories;

use App\Models\Floor;
use App\Models\Business;
use App\Models\Staff;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Floor>
 */
class FloorFactory extends Factory
{
    protected $model = Floor::class;

    public function definition(): array
    {
        return [
            'business_id' => Business::factory(),
            'floor_name' => $this->faker->words(2, true),
            'floor_workstations' => $this->faker->numberBetween(1, 20),
            'floormanager_id' => null,
            'floormanager_name' => null,
            'floor_status' => $this->faker->randomElement(['Active', 'InActive']),
            'created_by' => $this->faker->userName(),
            'created_on' => now(),
        ];
    }
}
