<?php

namespace Database\Factories;

use App\Models\Invoice;
use App\Models\Business;
use App\Models\Customers;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Invoice>
 */
class InvoiceFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Invoice::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'business_id' => Business::factory(),
            'customer_id' => Customers::factory(),
            'invoice_number' => $this->faker->unique()->numerify('INV-####'),
            'invoice_date' => now(),
            'customer_name' => $this->faker->name(),
            'customer_cell' => $this->faker->phoneNumber(),
            'customer_email' => $this->faker->email(),
            'sub_total' => $this->faker->randomFloat(2, 100, 1000),
            'paid_amount' => 0,
            'balance' => 0,
            'tax_total' => 0,
            'net_amount' => $this->faker->randomFloat(2, 100, 1000),
            'invoice_status' => 'valid',
            'invoice_type' => 'service',
            'payment_mode' => 'cash',
            'is_recovery' => 'No',
            'discount' => 0,
            'gross_amount' => $this->faker->randomFloat(2, 100, 1000),
            // Required NOT NULL field
            'remarks' => '', // Empty string for NOT NULL field
        ];
    }

    /**
     * Indicate that the invoice is a recovery invoice.
     */
    public function recovery(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_recovery' => 'Yes',
            'invoice_status' => 'valid',
            'balance' => $this->faker->randomFloat(2, 50, 500),
        ]);
    }
}
