<?php

namespace Database\Factories;

use App\Models\SMSLog;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SMSLog>
 */
class SMSLogFactory extends Factory
{
    protected $model = SMSLog::class;

    public function definition(): array
    {
        return [
            'business_id' => Business::factory(),
            'receiver' => '92' . $this->faker->numerify('##########'),
            'msgdata' => $this->faker->sentence(),
            'using' => $this->faker->randomElement(['System', 'Manual', 'Scheduled']),
            'sent_date' => $this->faker->dateTimeBetween('-1 month', 'now'),
            'status' => $this->faker->randomElement(['sent', 'failed', 'pending']),
        ];
    }
}
