<?php

namespace Database\Factories;

use App\Models\ScheduledTask;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ScheduledTask>
 */
class ScheduledTaskFactory extends Factory
{
    protected $model = ScheduledTask::class;

    public function definition(): array
    {
        return [
            'business_id' => Business::factory(),
            'task_name' => $this->faker->words(2, true),
            'msg' => $this->faker->sentence(),
            's_query' => 'SELECT * FROM customers LIMIT 10',
            'active' => $this->faker->randomElement(['Yes', 'No']),
        ];
    }
}
