<?php

namespace Database\Factories;

use App\Models\Staff;
use App\Models\Business;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Staff>
 */
class StaffFactory extends Factory
{
    protected $model = Staff::class;

    public function definition(): array
    {
        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        
        return [
            'business_id' => Business::factory(),
            'staff_firstname' => $firstName,
            'staff_lastname' => $lastName,
            'staff_fullname' => $firstName . ' ' . $lastName,
            'staff_cell' => '92' . $this->faker->numerify('##########'),
            'staff_phone1' => $this->faker->phoneNumber(),
            'staff_phone2' => null,
            'staff_address' => $this->faker->address(),
            'staff_eid' => null,
            'staff_image' => null,
            'staff_email' => $this->faker->unique()->safeEmail(),
            'staff_active' => 'Y',
            'staff_order' => $this->faker->numberBetween(1, 100),
            'staff_salary' => $this->faker->randomFloat(2, 10000, 100000),
            'staff_comment' => null,
            'staff_scheduler' => 'On',
            'staff_shared' => 'No',
            'fcm_id' => null,
            'staff_work_min' => null,
            'week_day_off' => null,
            'commission_mode' => null,
            'staff_commission_perc' => null,
            'commission_target' => null,
            'deduction_policy' => null,
            'provident_fund_rate' => null,
            'salary_monthly_tax' => null,
            'staff_designation' => null,
            'staff_department' => null,
            'staff_cnic' => null,
            'staff_date_of_joining' => null,
            'staff_bank_account' => null,
            'staff_bank_account_title' => null,
            'staff_bank' => null,
            'staff_annual_leaves' => null,
            'day_start_time' => null,
            'day_end_time' => null,
            'floor_id' => null,
            'floor' => null,
            'salary_type' => null,
            'next_of_kin_name' => null,
            'next_of_kin_number' => null,
            'date_of_birth' => null,
            'contract_validity' => null,
            'contract_number' => null,
            'staff_fingerprint_template_base64' => null,
            'staff_fingerprint' => null,
            'auto_time_out' => null,
            'created_by' => null,
            'contract_type' => null,
        ];
    }
}
