<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DefaultSuperUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $password = 'abc-123';
        $business = DB::table('business')->where('ho', 'Yes')->first();

        // Create supermexyon user
        $user_name = 'supermexyon';
        $user = User::updateOrCreate(
            [
                'user_name' => $user_name
            ],
            [
                'user_name' => $user_name,
                'user_password' => md5($password),
                'business_id' => $business->id_business ?? '1',
                'user_image' => 'avatar-2.jpg',
                'user_status' => 'Active',
            ]
        );

        $user->assignRole('Super User');

        if ($this->command) {
            $this->command->info('==============================');
            $this->command->info('Super User');
            $this->command->info('User     : ' . $user_name);
            $this->command->info('Password : ' . $password);
            $this->command->info('==============================');
        }

        // Create dev user
        $user_name = 'dev';
        $user = User::updateOrCreate(
            [
                'user_name' => $user_name
            ],
            [
                'user_name' => $user_name,
                'user_password' => md5($password),
                'business_id' => $business->id_business ?? '1',
                'user_image' => 'avatar-2.jpg',
                'user_status' => 'Active',
            ]
        );

        $user->assignRole('Super User');

        if ($this->command) {
            $this->command->info('==============================');
            $this->command->info('Super User');
            $this->command->info('User     : ' . $user_name);
            $this->command->info('Password : ' . $password);
            $this->command->info('==============================');
        }
    }
}
