<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MenusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Truncate the menus table
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('menus')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1');

        // Insert all menu data
        DB::table('menus')->insert($this->getMenusData());
    }

    protected function getMenusData(): array
    {
        return [
            ['id' => 1, 'name' => 'Dashboards', 'permission' => 'Dashboards', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => 'fluent-mdl2:b-i-dashboard', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 1.00],
            ['id' => 2, 'name' => 'Scheduler', 'permission' => 'Scheduler', 'route' => 'any', 'route_params' => '["scheduler"]', 'link_target' => '_self', 'icon' => 'ix:live-schedule', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 6.00],
            ['id' => 3, 'name' => 'Reception', 'permission' => 'Reception', 'route' => '', 'route_params' => NULL, 'link_target' => '_self', 'icon' => 'fluent:desk-32-regular', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 7.00],
            ['id' => 4, 'name' => 'Business', 'permission' => 'My_Business', 'route' => '', 'route_params' => NULL, 'link_target' => '_self', 'icon' => 'ep:location', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 34.00],
            ['id' => 5, 'name' => 'Procurement', 'permission' => 'Procurement', 'route' => '', 'route_params' => NULL, 'link_target' => '_self', 'icon' => 'fluent:spray-can-16-regular', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 61.00],
            ['id' => 6, 'name' => 'Accounting', 'permission' => 'Accounting', 'route' => '', 'route_params' => NULL, 'link_target' => '_self', 'icon' => 'game-icons:coins', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 85.00],
            ['id' => 7, 'name' => 'HRM', 'permission' => 'HR_Management', 'route' => '', 'route_params' => NULL, 'link_target' => '_self', 'icon' => 'clarity:employee-group-line', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 111.00],
            ['id' => 8, 'name' => 'Administration', 'permission' => 'administration', 'route' => '', 'route_params' => NULL, 'link_target' => '_self', 'icon' => 'mdi:account-cash-outline', 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '0', 'is_active' => '1', 'sort_order' => 141.00],
            ['id' => 9, 'name' => 'Services Dashboard', 'permission' => 'Services_Dashboard', 'route' => 'home', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '1', 'is_active' => '1', 'sort_order' => 1.00],
            ['id' => 10, 'name' => 'SaaS Dashboard', 'permission' => 'SaaS_Dashboard', 'route' => 'second', 'route_params' => '["dashboard", "saas"]', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '1', 'is_active' => '0', 'sort_order' => 5.00],
            ['id' => 11, 'name' => 'MISReports', 'permission' => 'MISReports', 'route' => 'reports', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '1', 'after_separator' => '0', 'parent_id' => '1', 'is_active' => '1', 'sort_order' => 10.00],
            ['id' => 12, 'name' => 'Today\'s Invoices', 'permission' => 'Todays_Invoices', 'route' => 'any', 'route_params' => '["today_invoices"]', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 8.00],
            ['id' => 13, 'name' => 'Today\'s Vouchers', 'permission' => 'Todays_Vouchers', 'route' => 'todays_vouchers', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 9.00],
            ['id' => 14, 'name' => 'Recovery Invoices', 'permission' => 'Recovery_Invoices', 'route' => 'any', 'route_params' => '["recovery_invoices"]', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 10.00],
            ['id' => 15, 'name' => 'Orders', 'permission' => 'Orders', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 11.00],
            ['id' => 16, 'name' => 'Daily Expenses', 'permission' => 'Daily_Expenses', 'route' => 'daily_expenses', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 14.00],
            ['id' => 17, 'name' => 'Appointments', 'permission' => 'Appointments', 'route' => 'any', 'route_params' => '["appointments"]', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 15.00],
            ['id' => 18, 'name' => 'Bookings', 'permission' => 'Bookings', 'route' => 'bookings', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 16.00],
            ['id' => 19, 'name' => 'Daily Sheets & Reports', 'permission' => 'Daily_Sheets_&_Reports', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 17.00],
            ['id' => 20, 'name' => 'Daily Sheet', 'permission' => 'Daily_Sheet', 'route' => 'daily_sheet', 'route_params' => NULL, 'link_target' => '_blank', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '19', 'is_active' => '1', 'sort_order' => 18.00],
            ['id' => 21, 'name' => 'Daily Summary', 'permission' => 'Daily_Summary', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '19', 'is_active' => '1', 'sort_order' => 19.00],
            ['id' => 22, 'name' => 'Staff Day Business', 'permission' => 'Staff_Day_Business', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '19', 'is_active' => '1', 'sort_order' => 20.00],
            ['id' => 23, 'name' => 'Service Lapse (Days)', 'permission' => 'Service_Lapse_(Days)', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '19', 'is_active' => '1', 'sort_order' => 21.00],
            ['id' => 24, 'name' => 'Staff Performace', 'permission' => 'Staff_Performace', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '19', 'is_active' => '1', 'sort_order' => 22.00],
            ['id' => 25, 'name' => 'Period Bookings', 'permission' => 'Period_Bookings', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '19', 'is_active' => '1', 'sort_order' => 23.00],
            ['id' => 26, 'name' => 'Agent Wise Bookings', 'permission' => 'Agent_Wise_Bookings', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '19', 'is_active' => '1', 'sort_order' => 24.00],
            ['id' => 27, 'name' => 'Store & POS', 'permission' => 'Store_&_POS', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 25.00],
            ['id' => 28, 'name' => 'Price List', 'permission' => 'Price_List', 'route' => 'services.price_list', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '27', 'is_active' => '1', 'sort_order' => 26.00],
            ['id' => 29, 'name' => 'Product List', 'permission' => 'Product_List', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '27', 'is_active' => '1', 'sort_order' => 27.00],
            ['id' => 30, 'name' => 'Un Invoiced Visits', 'permission' => 'Un_Invoiced_Visits', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '27', 'is_active' => '1', 'sort_order' => 28.00],
            ['id' => 31, 'name' => 'Dispatch', 'permission' => 'Dispatch', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '27', 'is_active' => '1', 'sort_order' => 29.00],
            ['id' => 32, 'name' => 'POS Retail', 'permission' => 'POS_Retail', 'route' => 'new_retail_invoice', 'route_params' => '{"order_id": 0}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '27', 'is_active' => '1', 'sort_order' => 30.00],
            ['id' => 33, 'name' => 'POS Service', 'permission' => 'POS_Service', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '27', 'is_active' => '1', 'sort_order' => 31.00],
            ['id' => 34, 'name' => 'Customer Records', 'permission' => 'Customer_Records', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '3', 'is_active' => '1', 'sort_order' => 32.00],
            ['id' => 35, 'name' => 'Eye Lash Records', 'permission' => 'Eye_Lash_Records', 'route' => 'eyelash_records', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '34', 'is_active' => '1', 'sort_order' => 1.00],
            ['id' => 36, 'name' => 'Facial Records', 'permission' => 'Facial_Records', 'route' => 'facial_records', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '34', 'is_active' => '1', 'sort_order' => 2.00],
            ['id' => 37, 'name' => 'Color Records', 'permission' => 'Color_Records', 'route' => 'color_records', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '34', 'is_active' => '1', 'sort_order' => 3.00],
            ['id' => 38, 'name' => 'Consultation Notes', 'permission' => 'Consultation_Notes', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '34', 'is_active' => '1', 'sort_order' => 33.00],
            ['id' => 39, 'name' => 'Customers', 'permission' => 'Customers', 'route' => 'customers', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '4', 'is_active' => '1', 'sort_order' => 35.00],
            ['id' => 40, 'name' => 'Services', 'permission' => 'Services', 'route' => 'services', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '4', 'is_active' => '1', 'sort_order' => 36.00],
            ['id' => 41, 'name' => 'Type / Category / Service', 'permission' => 'Type_/_Category_/_Service', 'route' => 'services', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '40', 'is_active' => '1', 'sort_order' => 37.00],
            ['id' => 42, 'name' => 'Deal Packages', 'permission' => 'Deal_Packages', 'route' => 'deal_packages', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '40', 'is_active' => '1', 'sort_order' => 38.00],
            ['id' => 43, 'name' => 'Services List', 'permission' => 'Services_List', 'route' => 'open_all_services_list', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'line-md:download-loop', 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '40', 'is_active' => '1', 'sort_order' => 39.00],
            ['id' => 44, 'name' => 'Packages List', 'permission' => 'Packages_List', 'route' => 'open_all_packages_list', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'line-md:download-loop', 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '40', 'is_active' => '1', 'sort_order' => 40.00],
            ['id' => 45, 'name' => 'Branch Setting', 'permission' => 'Branch_Setting', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '4', 'is_active' => '1', 'sort_order' => 41.00],
            ['id' => 46, 'name' => 'Branch Details', 'permission' => 'Branch_Details', 'route' => 'business.branches', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 42.00],
            ['id' => 47, 'name' => 'Cities / Areas', 'permission' => 'Cities_/_Areas', 'route' => 'cities_listing', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 43.00],
            ['id' => 48, 'name' => 'Stores', 'permission' => 'Stores', 'route' => 'stores', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 44.00],
            ['id' => 49, 'name' => 'Service Departments', 'permission' => 'Service_Departments', 'route' => 'service_departments', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 45.00],
            ['id' => 50, 'name' => 'Service Floors', 'permission' => 'Service_Floors', 'route' => 'service_floors', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 46.00],
            ['id' => 51, 'name' => 'Discount Configuration', 'permission' => 'Discount_Configuration', 'route' => 'discount_configuration', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 47.00],
            ['id' => 52, 'name' => 'Flexi-Pricing', 'permission' => 'Flexi-Pricing', 'route' => 'flexi_pricing.index', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 48.00],
            ['id' => 53, 'name' => 'Signed Consent', 'permission' => 'Signed_Consent', 'route' => 'consent_list', 'route_params' => NULL, 'link_target' => '_blank', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '34', 'is_active' => '1', 'sort_order' => 33.00],
            ['id' => 54, 'name' => 'Staff Block Time Reasons', 'permission' => 'Staff_Block_Time_Reasons', 'route' => 'block_events', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 50.00],
            ['id' => 55, 'name' => 'SMS Setup', 'permission' => 'SMS_Setup', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '4', 'is_active' => '1', 'sort_order' => 51.00],
            ['id' => 56, 'name' => 'Custom SMS', 'permission' => 'Custom_SMS', 'route' => 'sms.custom', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '55', 'is_active' => '1', 'sort_order' => 52.00],
            ['id' => 57, 'name' => 'SMS Log', 'permission' => 'SMS_Log', 'route' => 'sms.log', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '55', 'is_active' => '1', 'sort_order' => 53.00],
            ['id' => 58, 'name' => 'Scheduled Tasks', 'permission' => 'Scheduled_Tasks', 'route' => 'sms.scheduled-tasks', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '55', 'is_active' => '1', 'sort_order' => 54.00],
            ['id' => 59, 'name' => 'Records & Lists', 'permission' => 'Records_&_Lists', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '4', 'is_active' => '1', 'sort_order' => 55.00],
            ['id' => 60, 'name' => 'Facial Records', 'permission' => 'Facial_Records', 'route' => 'facial_records', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '59', 'is_active' => '1', 'sort_order' => 56.00],
            ['id' => 61, 'name' => 'Eye Lash Records', 'permission' => 'Eye_Lash_Records', 'route' => 'eyelash_records', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '59', 'is_active' => '1', 'sort_order' => 57.00],
            ['id' => 62, 'name' => 'Color Records', 'permission' => 'Color_Records', 'route' => 'color_records', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '59', 'is_active' => '1', 'sort_order' => 58.00],
            ['id' => 63, 'name' => 'Gift Vouchers', 'permission' => 'Gift_Vouchers', 'route' => 'gift_vouchers', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '59', 'is_active' => '1', 'sort_order' => 59.00],
            ['id' => 64, 'name' => 'Franchises', 'permission' => 'Franchises', 'route' => 'franchise', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '59', 'is_active' => '1', 'sort_order' => 5.00],
            ['id' => 65, 'name' => 'Inventory Management', 'permission' => 'Inventory_Management', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '5', 'is_active' => '1', 'sort_order' => 62.00],
            ['id' => 66, 'name' => 'Brands', 'permission' => 'Brands', 'route' => 'brands', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '65', 'is_active' => '1', 'sort_order' => 63.00],
            ['id' => 67, 'name' => 'Products', 'permission' => 'Products', 'route' => 'brands.products', 'route_params' => '{"id_brand": 0}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '65', 'is_active' => '1', 'sort_order' => 64.00],
            ['id' => 68, 'name' => 'Stock Management', 'permission' => 'Stock_Management', 'route' => 'store_stock_data', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'line-md:download-loop', 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '65', 'is_active' => '1', 'sort_order' => 65.00],
            ['id' => 69, 'name' => 'Supplier Management', 'permission' => 'Supplier_Management', 'route' => 'suppliers', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '65', 'is_active' => '1', 'sort_order' => 66.00],
            ['id' => 70, 'name' => 'Purchases', 'permission' => 'Purchases', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '5', 'is_active' => '1', 'sort_order' => 67.00],
            ['id' => 71, 'name' => 'Purchase Orders', 'permission' => 'Purchase_Orders', 'route' => 'purchase.purchase_orders', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'bxs:purchase-tag', 'child_icon_position' => 'start', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '70', 'is_active' => '1', 'sort_order' => 68.00],
            ['id' => 72, 'name' => 'Receiving Notes', 'permission' => 'Receiving_Notes', 'route' => 'reports.run', 'route_params' => '{"id":31}', 'link_target' => '_blank', 'icon' => NULL, 'child_icon' => 'game-icons:receive-money', 'child_icon_position' => 'start', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '70', 'is_active' => '1', 'sort_order' => 69.00],
            ['id' => 73, 'name' => 'Branch Transfers', 'permission' => 'Branch_Transfers', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '5', 'is_active' => '1', 'sort_order' => 70.00],
            ['id' => 74, 'name' => 'Requisitions', 'permission' => 'Requisitions', 'route' => 'branch_requisitions.open_requisition_list', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'codicon:git-pull-request-go-to-changes', 'child_icon_position' => 'start', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '73', 'is_active' => '1', 'sort_order' => 71.00],
            ['id' => 75, 'name' => 'Transfer Notes', 'permission' => 'Transfer_Notes', 'route' => 'transfer_notes.transfer_notes', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'mdi:transfer', 'child_icon_position' => 'start', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '73', 'is_active' => '1', 'sort_order' => 72.00],
            ['id' => 76, 'name' => 'Dispatches', 'permission' => 'Dispatches', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '5', 'is_active' => '1', 'sort_order' => 73.00],
            ['id' => 77, 'name' => 'Dispatch Requests', 'permission' => 'Dispatch_Requests', 'route' => 'dispatch_request.dispatch_requests', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'ic:outline-feedback', 'child_icon_position' => 'start', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '76', 'is_active' => '1', 'sort_order' => 74.00],
            ['id' => 78, 'name' => 'Direct Dispatches', 'permission' => 'Direct_Dispatches', 'route' => 'dispatch_notes.dispatch_notes', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => 'lsicon:vip-consume-filled', 'child_icon_position' => 'start', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '76', 'is_active' => '1', 'sort_order' => 75.00],
            ['id' => 79, 'name' => 'Reports & Notes', 'permission' => 'Reports_&_Notes', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '5', 'is_active' => '1', 'sort_order' => 76.00],
            ['id' => 80, 'name' => 'Purchase Reports', 'permission' => 'Purchase_Reports', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '79', 'is_active' => '1', 'sort_order' => 77.00],
            ['id' => 81, 'name' => 'Supplier Ledger', 'permission' => 'Supplier_Ledger', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '79', 'is_active' => '1', 'sort_order' => 78.00],
            ['id' => 82, 'name' => 'Dispatch Notes', 'permission' => 'Dispatch_Notes', 'route' => 'reports.run', 'route_params' => '{"id":33}', 'link_target' => '_blank', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '79', 'is_active' => '1', 'sort_order' => 79.00],
            ['id' => 83, 'name' => 'Transfer Notes', 'permission' => 'Transfer_Notes', 'route' => 'transfer_notes.transfer_notes', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '79', 'is_active' => '1', 'sort_order' => 80.00],
            ['id' => 84, 'name' => 'Adjustment Notes', 'permission' => 'Adjustment_Notes', 'route' => 'reports.run', 'route_params' => '{"id": 34}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '79', 'is_active' => '1', 'sort_order' => 81.00],
            ['id' => 85, 'name' => 'Receiving Notes', 'permission' => 'Receiving_Notes', 'route' => 'reports.run', 'route_params' => '{"id":31}', 'link_target' => '_blank', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '79', 'is_active' => '1', 'sort_order' => 82.00],
            ['id' => 86, 'name' => 'Return Notes', 'permission' => 'Return_Notes', 'route' => 'reports.run', 'route_params' => '{"id": 35}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '79', 'is_active' => '1', 'sort_order' => 83.00],
            ['id' => 87, 'name' => 'Compiled Kits', 'permission' => 'Compiled_Kits', 'route' => 'products.compiled_kits', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '5', 'is_active' => '1', 'sort_order' => 84.00],
            ['id' => 88, 'name' => 'Chart Of Accounts', 'permission' => 'Chart_Of_Accounts', 'route' => 'accounts.chart_of_accounts', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 86.00],
            ['id' => 89, 'name' => 'Account Vouchers', 'permission' => 'Account_Vouchers', 'route' => 'accounts.open_account_vouchers', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 87.00],
            ['id' => 90, 'name' => 'General Ledger', 'permission' => 'General_Ledger', 'route' => 'accounts.open_general_ledger', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 88.00],
            ['id' => 91, 'name' => 'Financial Statements', 'permission' => 'Financial_Statements', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 89.00],
            ['id' => 92, 'name' => 'Trial Balance', 'permission' => 'Trial_Balance', 'route' => 'accounts.open_trial_balance', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '91', 'is_active' => '1', 'sort_order' => 90.00],
            ['id' => 93, 'name' => 'Trial Movement', 'permission' => 'Trial_Movement', 'route' => 'accounts.open_trial_movement', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '91', 'is_active' => '1', 'sort_order' => 91.00],
            ['id' => 94, 'name' => 'Balance Sheet', 'permission' => 'Balance_Sheet', 'route' => 'accounts.open_balance_sheet', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '91', 'is_active' => '1', 'sort_order' => 92.00],
            ['id' => 95, 'name' => 'Profit & Loss', 'permission' => 'Profit_&_Loss', 'route' => 'accounts.open_profit_and_loss', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '91', 'is_active' => '1', 'sort_order' => 93.00],
            ['id' => 96, 'name' => 'Fiscal Year Closing', 'permission' => 'Fiscal_Year_Closing', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 94.00],
            ['id' => 97, 'name' => 'Fiscal Year Closing', 'permission' => 'Fiscal_Year_Closing', 'route' => 'accounts.accounts_closing', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '96', 'is_active' => '1', 'sort_order' => 95.00],
            ['id' => 98, 'name' => 'Fiscal Year Closing History', 'permission' => 'Fiscal_Year_Closing_History', 'route' => 'accounts.accounts_closing_history', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '96', 'is_active' => '1', 'sort_order' => 96.00],
            ['id' => 99, 'name' => 'Reports', 'permission' => 'Reports', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 97.00],
            ['id' => 100, 'name' => 'Aging Receivables', 'permission' => 'Aging_Receivables', 'route' => 'accounts.receivables', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '99', 'is_active' => '1', 'sort_order' => 98.00],
            ['id' => 101, 'name' => 'Aging Payables', 'permission' => 'Aging_Payables', 'route' => 'accounts.aging_payables', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '99', 'is_active' => '1', 'sort_order' => 99.00],
            ['id' => 102, 'name' => 'Ledgers', 'permission' => 'Ledgers', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 100.00],
            ['id' => 103, 'name' => 'Supplier Ledger', 'permission' => 'Supplier_Ledger', 'route' => 'accounts.business_partner_ledger', 'route_params' => '{"type": "Suppliers"}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '102', 'is_active' => '1', 'sort_order' => 101.00],
            ['id' => 104, 'name' => 'Customer Ledger', 'permission' => 'Customer_Ledger', 'route' => 'accounts.business_partner_ledger', 'route_params' => '{"type": "Customers"}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '102', 'is_active' => '1', 'sort_order' => 102.00],
            ['id' => 105, 'name' => 'Staff Ledger', 'permission' => 'Staff_Ledger', 'route' => 'accounts.business_partner_ledger', 'route_params' => '{"type": "Staff"}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '102', 'is_active' => '1', 'sort_order' => 103.00],
            ['id' => 106, 'name' => 'Franchise Ledger', 'permission' => 'Franchise_Ledger', 'route' => 'accounts.business_partner_ledger', 'route_params' => '{"type": "Franchise"}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '102', 'is_active' => '1', 'sort_order' => 104.00],
            ['id' => 107, 'name' => 'Branch Ledger', 'permission' => 'Branch_Ledger', 'route' => 'accounts.business_partner_ledger', 'route_params' => '{"type": "Branch"}', 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '102', 'is_active' => '1', 'sort_order' => 105.00],
            ['id' => 108, 'name' => 'Franchise', 'permission' => 'Franchise', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '6', 'is_active' => '1', 'sort_order' => 106.00],
            ['id' => 109, 'name' => 'Franchise', 'permission' => 'Franchise', 'route' => 'franchise', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '108', 'is_active' => '1', 'sort_order' => 107.00],
            ['id' => 110, 'name' => 'Franchise Orders', 'permission' => 'Franchise_Orders', 'route' => 'franchise.franchise_orders', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '108', 'is_active' => '1', 'sort_order' => 108.00],
            ['id' => 111, 'name' => 'Franchise Aging', 'permission' => 'Franchise_Aging', 'route' => 'franchise.franchise_aging', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '108', 'is_active' => '1', 'sort_order' => 109.00],
            ['id' => 112, 'name' => 'Franchise Product Sale Detail', 'permission' => 'Franchise_Product_Sale_Detail', 'route' => 'franchise.franchise_product_sale_details', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '108', 'is_active' => '1', 'sort_order' => 110.00],
            ['id' => 113, 'name' => 'Staff Management', 'permission' => 'Staff_Management', 'route' => 'staff.staff_list', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 112.00],
            ['id' => 114, 'name' => 'Login Logs', 'permission' => 'Login_Logs', 'route' => 'login_logs.index', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 113.00],
            ['id' => 115, 'name' => 'Attendance Requests', 'permission' => 'Attendance_Requests', 'route' => 'attendance.requests', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 114.00],
            ['id' => 116, 'name' => 'Pay-Roll Management', 'permission' => 'Pay-Roll_Management', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 115.00],
            ['id' => 117, 'name' => 'Staff Payable Voucher Calculator', 'permission' => 'Staff_Payable_Voucher_Calculator', 'route' => 'hrm.staff_payment_calculator', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '116', 'is_active' => '1', 'sort_order' => 116.00],
            ['id' => 118, 'name' => 'Staff Payments', 'permission' => 'Staff_Payments', 'route' => 'hrm.staff_payables_receivables', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '116', 'is_active' => '1', 'sort_order' => 117.00],
            ['id' => 119, 'name' => 'Staff Payment Slip Generation', 'permission' => 'Staff_Payment_Slip_Generation', 'route' => 'hrm.staff_paymentslips', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '116', 'is_active' => '1', 'sort_order' => 118.00],
            ['id' => 120, 'name' => 'Staff Loans & Advances', 'permission' => 'Staff_Loans_&_Advances', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '116', 'is_active' => '1', 'sort_order' => 119.00],
            ['id' => 121, 'name' => 'Leave Management', 'permission' => 'Leave_Management', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 120.00],
            ['id' => 122, 'name' => 'Staff Leave Applications', 'permission' => 'Staff_Leave_Applications', 'route' => 'hrm.leave_applications', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '121', 'is_active' => '1', 'sort_order' => 121.00],
            ['id' => 123, 'name' => 'Staff Leave Approval', 'permission' => 'Staff_Leave_Approval', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '121', 'is_active' => '1', 'sort_order' => 122.00],
            ['id' => 124, 'name' => 'Staff Leave Report', 'permission' => 'Staff_Leave_Report', 'route' => 'hrm.staff_leave_report', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '121', 'is_active' => '1', 'sort_order' => 123.00],
            ['id' => 125, 'name' => 'Loan & Advances', 'permission' => 'Loan_&_Advances', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 125.00],
            ['id' => 126, 'name' => 'Staff Loan Applications', 'permission' => 'Staff_Loan_Applications', 'route' => 'hrm.advance_salary_applications', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '125', 'is_active' => '1', 'sort_order' => 126.00],
            ['id' => 127, 'name' => 'Staff Loan Approval', 'permission' => 'Staff_Loan_Approval', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '125', 'is_active' => '1', 'sort_order' => 127.00],
            ['id' => 128, 'name' => 'Staff Loan Report', 'permission' => 'Staff_Loan_Report', 'route' => 'hrm.loan_report', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '125', 'is_active' => '1', 'sort_order' => 128.00],
            ['id' => 129, 'name' => 'Reports & Lists', 'permission' => 'Reports_&_Lists', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 129.00],
            ['id' => 130, 'name' => 'Staff Attendance Report', 'permission' => 'Staff_Attendance_Report', 'route' => 'hrm.staff_attendance_report', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '129', 'is_active' => '1', 'sort_order' => 130.00],
            ['id' => 131, 'name' => 'Yearly Attendance Report', 'permission' => 'Yearly_Attendance_Report', 'route' => 'hrm.yearly_attendance_report', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '1', 'parent_id' => '129', 'is_active' => '1', 'sort_order' => 131.00],
            ['id' => 132, 'name' => 'Staff Provident Fund', 'permission' => 'Staff_Provident_Fund', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '129', 'is_active' => '1', 'sort_order' => 132.00],
            // Note: ID 133 is missing
            ['id' => 134, 'name' => 'Staff Deductions Report', 'permission' => 'Staff_Deductions_Report', 'route' => 'hrm.staff_deductions_report', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '129', 'is_active' => '1', 'sort_order' => 134.00],
            ['id' => 135, 'name' => 'HR Setup', 'permission' => 'HR_Setup', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '7', 'is_active' => '1', 'sort_order' => 135.00],
            ['id' => 136, 'name' => 'Mark Holidays Overtime & Leave Days', 'permission' => 'Mark_Gazetted_Holidays', 'route' => 'mark_gazetted_holidays', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '135', 'is_active' => '1', 'sort_order' => 136.00],
            ['id' => 137, 'name' => 'Deduction Policies', 'permission' => 'Deduction_Policies', 'route' => 'hrm.deduction_policies', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '135', 'is_active' => '1', 'sort_order' => 137.00],
            ['id' => 138, 'name' => 'Staff Allowances', 'permission' => 'Staff_Allowances', 'route' => 'staff.staff_allowances', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '135', 'is_active' => '1', 'sort_order' => 138.00],
            ['id' => 139, 'name' => 'Staff Loan & Advance Types', 'permission' => 'Staff_Loan_&_Advance_Types', 'route' => NULL, 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '135', 'is_active' => '1', 'sort_order' => 139.00],
            ['id' => 140, 'name' => 'Account Mapping', 'permission' => 'Account_Mapping', 'route' => 'account_events', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '8', 'is_active' => '1', 'sort_order' => 142.00],
            ['id' => 141, 'name' => 'Retail Dashboard', 'permission' => 'Retail Dashboard', 'route' => 'dashboard.retaildashboard', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '1', 'is_active' => '1', 'sort_order' => 2.00],
            ['id' => 142, 'name' => 'Product Orders', 'permission' => 'Product_Orders', 'route' => 'product_orders', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '15', 'is_active' => '1', 'sort_order' => 12.00],
            ['id' => 143, 'name' => 'Online Orders', 'permission' => 'Online Orders', 'route' => 'product_orders_online', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '15', 'is_active' => '1', 'sort_order' => 13.00],
            ['id' => 144, 'name' => 'Tickets', 'permission' => 'Tickets', 'route' => 'tickets.index', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '4', 'is_active' => '0', 'sort_order' => 60.00],
            ['id' => 145, 'name' => 'Leave Policies', 'permission' => 'Leave Policies', 'route' => 'hrm.leave_policies', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '135', 'is_active' => '1', 'sort_order' => 140.00],
            ['id' => 146, 'name' => 'Staff Leave Types', 'permission' => NULL, 'route' => 'hrm.leave_types', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '121', 'is_active' => '1', 'sort_order' => 124.00],
            ['id' => 147, 'name' => 'Head Office Dashboard', 'permission' => 'Head Office Dashboard', 'route' => 'dashboard.head_office_dashboard', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '1', 'is_active' => '1', 'sort_order' => 4.00],
            ['id' => 148, 'name' => 'Staff Listing', 'permission' => 'Staff_Listing', 'route' => 'staff.staff_list', 'route_params' => NULL, 'link_target' => '_self', 'icon' => NULL, 'child_icon' => NULL, 'child_icon_position' => 'end', 'before_separator' => '0', 'after_separator' => '0', 'parent_id' => '45', 'is_active' => '1', 'sort_order' => 49.00],
        ];
    }
}