<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PermissionSystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->resetSpatieTables();
        $this->resetMenusTable();

        $this->call([
            PermissionsSeeder::class,
            RolesSeeder::class,
            RolePermissionSeeder::class,
            MenusSeeder::class,
            DefaultSuperUserSeeder::class,
        ]);
    }

    protected function resetSpatieTables()
    {
        $cache_key = config('permission.cache.key');

        DB::table('cache')
        ->where('key', $cache_key)
        ->delete();

        app()->make(\Spatie\Permission\PermissionRegistrar::class)->forgetCachedPermissions();
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        DB::table('spatie_role_has_permissions')->truncate();
        DB::table('spatie_model_has_permissions')->truncate();
        DB::table('spatie_model_has_roles')->truncate();
        DB::table('spatie_roles')->truncate();
        DB::table('spatie_permissions')->truncate();
        
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }

    protected function resetMenusTable()
    {
        DB::table('menus')->truncate();
    }
}
