<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Permission::insert($this->skedwise_permissions());
    }

    public function skedwise_permissions()
    {
        return [
            ['id' => 1,   'name' => 'Dashboards',                         'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 2,   'name' => 'Scheduler',                          'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 3,   'name' => 'Reception',                          'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 4,   'name' => 'My_Business',                        'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 5,   'name' => 'Procurement',                        'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 6,   'name' => 'Accounting',                         'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 7,   'name' => 'HR_Management',                      'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 8,   'name' => 'administration',                     'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 9,   'name' => 'Services_Dashboard',                 'guard_name' => 'web', 'parent_id' => '1'  ],
            ['id' => 10,  'name' => 'SaaS_Dashboard',                     'guard_name' => 'web', 'parent_id' => '1'  ],
            ['id' => 11,  'name' => 'MISReports',                         'guard_name' => 'web', 'parent_id' => '1'  ],
            ['id' => 12,  'name' => 'Todays_Invoices',                    'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 13,  'name' => 'Todays_Vouchers',                    'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 14,  'name' => 'Recovery_Invoices',                  'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 15,  'name' => 'Product_Orders',                     'guard_name' => 'web', 'parent_id' => '179'],
            ['id' => 16,  'name' => 'Daily_Expenses',                     'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 17,  'name' => 'Appointments',                       'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 18,  'name' => 'Bookings',                           'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 19,  'name' => 'Daily_Sheets_&_Reports',             'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 20,  'name' => 'Daily_Sheet',                        'guard_name' => 'web', 'parent_id' => '19' ],
            ['id' => 21,  'name' => 'Daily_Summary',                      'guard_name' => 'web', 'parent_id' => '19' ],
            ['id' => 22,  'name' => 'Staff_Day_Business',                 'guard_name' => 'web', 'parent_id' => '19' ],
            ['id' => 23,  'name' => 'Service_Lapse_(Days)',               'guard_name' => 'web', 'parent_id' => '19' ],
            ['id' => 24,  'name' => 'Staff_Performace',                   'guard_name' => 'web', 'parent_id' => '19' ],
            ['id' => 25,  'name' => 'Period_Bookings',                    'guard_name' => 'web', 'parent_id' => '19' ],
            ['id' => 26,  'name' => 'Agent_Wise_Bookings',                'guard_name' => 'web', 'parent_id' => '19' ],
            ['id' => 27,  'name' => 'Store_&_POS',                        'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 28,  'name' => 'Price_List',                         'guard_name' => 'web', 'parent_id' => '27' ],
            ['id' => 29,  'name' => 'Product_List',                       'guard_name' => 'web', 'parent_id' => '27' ],
            ['id' => 30,  'name' => 'Un_Invoiced_Visits',                 'guard_name' => 'web', 'parent_id' => '27' ],
            ['id' => 31,  'name' => 'Dispatch',                           'guard_name' => 'web', 'parent_id' => '27' ],
            ['id' => 32,  'name' => 'POS_Retail',                         'guard_name' => 'web', 'parent_id' => '27' ],
            ['id' => 33,  'name' => 'POS_Service',                        'guard_name' => 'web', 'parent_id' => '27' ],
            ['id' => 34,  'name' => 'Customer_Records',                   'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 35,  'name' => 'Eye_Lash_Records',                   'guard_name' => 'web', 'parent_id' => '34' ],
            ['id' => 36,  'name' => 'Facial_Records',                     'guard_name' => 'web', 'parent_id' => '34' ],
            ['id' => 37,  'name' => 'Color_Records',                      'guard_name' => 'web', 'parent_id' => '34' ],
            ['id' => 38,  'name' => 'Consultation_Notes',                 'guard_name' => 'web', 'parent_id' => '34' ],
            ['id' => 39,  'name' => 'Customers',                          'guard_name' => 'web', 'parent_id' => '4'  ],
            ['id' => 40,  'name' => 'Services',                           'guard_name' => 'web', 'parent_id' => '4'  ],
            ['id' => 41,  'name' => 'Type_/_Category_/_Service',          'guard_name' => 'web', 'parent_id' => '40' ],
            ['id' => 42,  'name' => 'Deal_Packages',                      'guard_name' => 'web', 'parent_id' => '40' ],
            ['id' => 43,  'name' => 'Services_List',                      'guard_name' => 'web', 'parent_id' => '40' ],
            ['id' => 44,  'name' => 'Packages_List',                      'guard_name' => 'web', 'parent_id' => '40' ],
            ['id' => 45,  'name' => 'Branch_Setting',                     'guard_name' => 'web', 'parent_id' => '4'  ],
            ['id' => 46,  'name' => 'Branch_Details',                     'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 47,  'name' => 'Cities_/_Areas',                     'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 48,  'name' => 'Stores',                             'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 49,  'name' => 'Service_Departments',                'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 50,  'name' => 'Service_Floors',                     'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 51,  'name' => 'Discount_Configuration',             'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 52,  'name' => 'Flexi-Pricing',                      'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 53,  'name' => 'Staff_Listing',                      'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 54,  'name' => 'Staff_Block_Time_Reasons',           'guard_name' => 'web', 'parent_id' => '45' ],
            ['id' => 55,  'name' => 'SMS_Setup',                          'guard_name' => 'web', 'parent_id' => '4'  ],
            ['id' => 56,  'name' => 'Custom_SMS',                         'guard_name' => 'web', 'parent_id' => '55' ],
            ['id' => 57,  'name' => 'SMS_Log',                            'guard_name' => 'web', 'parent_id' => '55' ],
            ['id' => 58,  'name' => 'Scheduled_Tasks',                    'guard_name' => 'web', 'parent_id' => '55' ],
            ['id' => 59,  'name' => 'Records_&_Lists',                    'guard_name' => 'web', 'parent_id' => '4'  ],
            ['id' => 60,  'name' => 'Gift_Vouchers',                      'guard_name' => 'web', 'parent_id' => '59' ],
            ['id' => 61,  'name' => 'Franchises',                         'guard_name' => 'web', 'parent_id' => '59' ],
            ['id' => 62,  'name' => 'Inventory_Management',               'guard_name' => 'web', 'parent_id' => '5'  ],
            ['id' => 63,  'name' => 'Brands',                             'guard_name' => 'web', 'parent_id' => '62' ],
            ['id' => 64,  'name' => 'Products',                           'guard_name' => 'web', 'parent_id' => '62' ],
            ['id' => 65,  'name' => 'Stock_Management',                   'guard_name' => 'web', 'parent_id' => '62' ],
            ['id' => 66,  'name' => 'Supplier_Management',                'guard_name' => 'web', 'parent_id' => '62' ],
            ['id' => 67,  'name' => 'Purchases',                          'guard_name' => 'web', 'parent_id' => '5'  ],
            ['id' => 68,  'name' => 'Purchase_Orders',                    'guard_name' => 'web', 'parent_id' => '67' ],
            ['id' => 69,  'name' => 'Receiving_Notes',                    'guard_name' => 'web', 'parent_id' => '67' ],
            ['id' => 70,  'name' => 'Branch_Transfers',                   'guard_name' => 'web', 'parent_id' => '5'  ],
            ['id' => 71,  'name' => 'Requisitions',                       'guard_name' => 'web', 'parent_id' => '70' ],
            ['id' => 72,  'name' => 'Transfer_Notes',                     'guard_name' => 'web', 'parent_id' => '70' ],
            ['id' => 73,  'name' => 'Dispatches',                         'guard_name' => 'web', 'parent_id' => '5'  ],
            ['id' => 74,  'name' => 'Dispatch_Requests',                  'guard_name' => 'web', 'parent_id' => '73' ],
            ['id' => 75,  'name' => 'Direct_Dispatches',                  'guard_name' => 'web', 'parent_id' => '73' ],
            ['id' => 76,  'name' => 'Reports_&_Notes',                    'guard_name' => 'web', 'parent_id' => '5'  ],
            ['id' => 77,  'name' => 'Purchase_Reports',                   'guard_name' => 'web', 'parent_id' => '76' ],
            ['id' => 78,  'name' => 'Supplier_Ledger',                    'guard_name' => 'web', 'parent_id' => '76' ],
            ['id' => 79,  'name' => 'Dispatch_Notes',                     'guard_name' => 'web', 'parent_id' => '76' ],
            ['id' => 80,  'name' => 'Adjustment_Notes',                   'guard_name' => 'web', 'parent_id' => '76' ],
            ['id' => 81,  'name' => 'Return_Notes',                       'guard_name' => 'web', 'parent_id' => '76' ],
            ['id' => 82,  'name' => 'Compiled_Kits',                      'guard_name' => 'web', 'parent_id' => '5'  ],
            ['id' => 83,  'name' => 'Chart_Of_Accounts',                  'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 84,  'name' => 'Account_Vouchers',                   'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 85,  'name' => 'General_Ledger',                     'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 86,  'name' => 'Financial_Statements',               'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 87,  'name' => 'Trial_Balance',                      'guard_name' => 'web', 'parent_id' => '86' ],
            ['id' => 88,  'name' => 'Trial_Movement',                     'guard_name' => 'web', 'parent_id' => '86' ],
            ['id' => 89,  'name' => 'Balance_Sheet',                      'guard_name' => 'web', 'parent_id' => '86' ],
            ['id' => 90,  'name' => 'Profit_&_Loss',                      'guard_name' => 'web', 'parent_id' => '86' ],
            ['id' => 91,  'name' => 'Fiscal_Year_Closing',                'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 92,  'name' => 'Fiscal_Year_Closing_History',        'guard_name' => 'web', 'parent_id' => '91' ],
            ['id' => 93,  'name' => 'Reports',                            'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 94,  'name' => 'Aging_Receivables',                  'guard_name' => 'web', 'parent_id' => '93' ],
            ['id' => 95,  'name' => 'Aging_Payables',                     'guard_name' => 'web', 'parent_id' => '93' ],
            ['id' => 96,  'name' => 'Ledgers',                            'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 97,  'name' => 'Customer_Ledger',                    'guard_name' => 'web', 'parent_id' => '96' ],
            ['id' => 98,  'name' => 'Staff_Ledger',                       'guard_name' => 'web', 'parent_id' => '96' ],
            ['id' => 99,  'name' => 'Franchise_Ledger',                   'guard_name' => 'web', 'parent_id' => '96' ],
            ['id' => 100, 'name' => 'Branch_Ledger',                      'guard_name' => 'web', 'parent_id' => '96' ],
            ['id' => 101, 'name' => 'Franchise',                          'guard_name' => 'web', 'parent_id' => '6'  ],
            ['id' => 102, 'name' => 'Franchise_Orders',                   'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 103, 'name' => 'Franchise_Aging',                    'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 104, 'name' => 'Franchise_Product_Sale_Detail',      'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 105, 'name' => 'Staff_Management',                   'guard_name' => 'web', 'parent_id' => '7'  ],
            ['id' => 107, 'name' => 'Attendance_Requests',                'guard_name' => 'web', 'parent_id' => '7'  ],
            ['id' => 108, 'name' => 'Pay-Roll_Management',                'guard_name' => 'web', 'parent_id' => '7'  ],
            ['id' => 109, 'name' => 'Staff_Payable_Voucher_Calculator',   'guard_name' => 'web', 'parent_id' => '108'],
            ['id' => 110, 'name' => 'Staff_Payments',                     'guard_name' => 'web', 'parent_id' => '108'],
            ['id' => 111, 'name' => 'Staff_Payment_Slip_Generation',      'guard_name' => 'web', 'parent_id' => '108'],
            ['id' => 112, 'name' => 'Staff_Loans_&_Advances',             'guard_name' => 'web', 'parent_id' => '108'],
            ['id' => 113, 'name' => 'Leave_Management',                   'guard_name' => 'web', 'parent_id' => '7'  ],
            ['id' => 114, 'name' => 'Staff_Leave_Applications',           'guard_name' => 'web', 'parent_id' => '113'],
            ['id' => 115, 'name' => 'Staff_Leave_Approval',               'guard_name' => 'web', 'parent_id' => '113'],
            ['id' => 116, 'name' => 'Staff_Leave_Report',                 'guard_name' => 'web', 'parent_id' => '113'],
            ['id' => 117, 'name' => 'Loan_&_Advances',                    'guard_name' => 'web', 'parent_id' => '7'  ],
            ['id' => 118, 'name' => 'Staff_Loan_Applications',            'guard_name' => 'web', 'parent_id' => '117'],
            ['id' => 119, 'name' => 'Staff_Loan_Approval',                'guard_name' => 'web', 'parent_id' => '117'],
            ['id' => 120, 'name' => 'Staff_Loan_Report',                  'guard_name' => 'web', 'parent_id' => '117'],
            ['id' => 121, 'name' => 'Reports_&_Lists',                    'guard_name' => 'web', 'parent_id' => '7'  ],
            ['id' => 122, 'name' => 'Staff_Attendance_Report',            'guard_name' => 'web', 'parent_id' => '121'],
            ['id' => 123, 'name' => 'Yearly_Attendance_Report',           'guard_name' => 'web', 'parent_id' => '121'],
            ['id' => 124, 'name' => 'Staff_Provident_Fund',               'guard_name' => 'web', 'parent_id' => '121'],
            ['id' => 125, 'name' => 'Staff_Deductions_Report',            'guard_name' => 'web', 'parent_id' => '121'],
            ['id' => 126, 'name' => 'HR_Setup',                           'guard_name' => 'web', 'parent_id' => '7'  ],
            ['id' => 127, 'name' => 'Mark_Gazetted_Holidays',             'guard_name' => 'web', 'parent_id' => '126'],
            ['id' => 128, 'name' => 'Deduction_Policies',                 'guard_name' => 'web', 'parent_id' => '126'],
            ['id' => 129, 'name' => 'Staff_Allowances',                   'guard_name' => 'web', 'parent_id' => '126'],
            ['id' => 130, 'name' => 'Staff_Loan_&_Advance_Types',         'guard_name' => 'web', 'parent_id' => '126'],
            ['id' => 131, 'name' => 'Account_Mapping',                    'guard_name' => 'web', 'parent_id' => '8'  ],
            ['id' => 132, 'name' => 'Retail Dashboard',                   'guard_name' => 'web', 'parent_id' => '1'  ],
            ['id' => 133, 'name' => 'Total_Invoiced_Visits',              'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 134, 'name' => 'Total_Revenue',                      'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 135, 'name' => 'Repeat_Customers',                   'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 136, 'name' => 'Customer_Satisfaction',              'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 137, 'name' => 'Top_Service_Categories',             'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 138, 'name' => 'Footfall_Heatmap',                   'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 139, 'name' => 'Monthly_Performance',                'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 140, 'name' => 'Top_Performing_Staff',               'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 141, 'name' => 'Top_Customers',                      'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 142, 'name' => 'Yearly_Sale_Comparison',             'guard_name' => 'web', 'parent_id' => '9'  ],
            ['id' => 143, 'name' => 'mis_report-Appointments',            'guard_name' => 'web', 'parent_id' => '11' ],
            ['id' => 144, 'name' => 'mis_report-Service_Sales',           'guard_name' => 'web', 'parent_id' => '11' ],
            ['id' => 145, 'name' => 'mis_report-Retail_&_Stock',          'guard_name' => 'web', 'parent_id' => '11' ],
            ['id' => 146, 'name' => 'mis_report-Staff',                   'guard_name' => 'web', 'parent_id' => '11' ],
            ['id' => 147, 'name' => 'mis_report-Invoices',                'guard_name' => 'web', 'parent_id' => '11' ],
            ['id' => 148, 'name' => 'mis_report-Other_Reports',           'guard_name' => 'web', 'parent_id' => '11' ],
            ['id' => 149, 'name' => 'Retail_Receivable',                  'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 150, 'name' => 'Retail_Advances',                    'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 151, 'name' => 'Unreceived_Goods',                   'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 152, 'name' => 'Retail_Revenue',                     'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 153, 'name' => 'Top_Products_Sales',                 'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 154, 'name' => 'Category-wise_Stock_Sales_Analysis', 'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 155, 'name' => 'Month_Collection_Breakup',           'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 156, 'name' => 'Top_Retail_Customers',               'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 157, 'name' => 'Product_Categories_Status',          'guard_name' => 'web', 'parent_id' => '132'],
            ['id' => 158, 'name' => 'Cash_Register',                      'guard_name' => 'web', 'parent_id' => '2'  ],
            ['id' => 159, 'name' => 'Close_Till',                         'guard_name' => 'web', 'parent_id' => '2'  ],
            ['id' => 160, 'name' => 'Attendance',                         'guard_name' => 'web', 'parent_id' => '2'  ],
            ['id' => 161, 'name' => 'view-Recovery_Invoices',             'guard_name' => 'web', 'parent_id' => '14' ],
            ['id' => 162, 'name' => 'Bad_Dept-Recovery_Invoices',         'guard_name' => 'web', 'parent_id' => '14' ],
            ['id' => 163, 'name' => 'Recover-Recovery_Invoices',          'guard_name' => 'web', 'parent_id' => '14' ],
            ['id' => 164, 'name' => 'view-Product_Orders',                'guard_name' => 'web', 'parent_id' => '15' ],
            ['id' => 165, 'name' => 'delete-Product_Orders',              'guard_name' => 'web', 'parent_id' => '15' ],
            ['id' => 166, 'name' => 'add-Product_Orders',                 'guard_name' => 'web', 'parent_id' => '15' ],
            ['id' => 167, 'name' => 'create-Daily_Expenses',              'guard_name' => 'web', 'parent_id' => '16' ],
            ['id' => 168, 'name' => 'delete-Daily_Expenses',              'guard_name' => 'web', 'parent_id' => '16' ],
            ['id' => 169, 'name' => 'create-Visit',                       'guard_name' => 'web', 'parent_id' => '17' ],
            ['id' => 170, 'name' => 'edit-Visit',                         'guard_name' => 'web', 'parent_id' => '17' ],
            ['id' => 171, 'name' => 'create-customer',                    'guard_name' => 'web', 'parent_id' => '39' ],
            ['id' => 172, 'name' => 'edit-customer',                      'guard_name' => 'web', 'parent_id' => '39' ],
            ['id' => 173, 'name' => 'view-customer',                      'guard_name' => 'web', 'parent_id' => '39' ],
            ['id' => 174, 'name' => 'create-Account_Vouchers',            'guard_name' => 'web', 'parent_id' => '84' ],
            ['id' => 175, 'name' => 'edit-Account_Vouchers',              'guard_name' => 'web', 'parent_id' => '84' ],
            ['id' => 176, 'name' => 'view-Account_Vouchers',              'guard_name' => 'web', 'parent_id' => '84' ],
            ['id' => 177, 'name' => 'delete-Account_Vouchers',            'guard_name' => 'web', 'parent_id' => '84' ],
            ['id' => 178, 'name' => 'create-Bookings',                    'guard_name' => 'web', 'parent_id' => '18' ],
            ['id' => 179, 'name' => 'Orders',                             'guard_name' => 'web', 'parent_id' => '3'  ],
            ['id' => 180, 'name' => 'Online Orders',                      'guard_name' => 'web', 'parent_id' => '179'],
            ['id' => 181, 'name' => 'Tickets',                            'guard_name' => 'web', 'parent_id' => '4'  ],
            ['id' => 182, 'name' => 'create-Chart_Of_Accounts',           'guard_name' => 'web', 'parent_id' => '83' ],
            ['id' => 183, 'name' => 'edit-Chart_Of_Accounts',             'guard_name' => 'web', 'parent_id' => '83' ],
            ['id' => 184, 'name' => 'create-Franchise_Orders',            'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 185, 'name' => 'edit-Franchise_Orders',              'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 186, 'name' => 'create-Franchise',                   'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 187, 'name' => 'edit-Franchise',                     'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 188, 'name' => 'delete-Franchise_Orders',            'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 189, 'name' => 'create_invoice-Franchise_Orders',    'guard_name' => 'web', 'parent_id' => '101'],
            ['id' => 190, 'name' => 'create-brand',                       'guard_name' => 'web', 'parent_id' => '63' ],
            ['id' => 191, 'name' => 'edit-brand',                         'guard_name' => 'web', 'parent_id' => '63' ],
            ['id' => 192, 'name' => 'create-brand_product',               'guard_name' => 'web', 'parent_id' => '64' ],
            ['id' => 193, 'name' => 'edit-brand_product',                 'guard_name' => 'web', 'parent_id' => '64' ],
            ['id' => 194, 'name' => 'add-product_retail_price',           'guard_name' => 'web', 'parent_id' => '64' ],
            ['id' => 195, 'name' => 'add-product_purchase_price',         'guard_name' => 'web', 'parent_id' => '64' ],
            ['id' => 196, 'name' => 'create-Purchase_Orders',             'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 197, 'name' => 'edit-Purchase_Orders',               'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 198, 'name' => 'create_grn-Purchase_Orders',         'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 199, 'name' => 'view_grn-Purchase_Orders',           'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 200, 'name' => 'change_price_grn-Purchase_Orders',   'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 201, 'name' => 'change_price-Purchase_Orders',       'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 202, 'name' => 'return_GRN-Purchase_Orders',         'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 203, 'name' => 'add_payment-Purchase_Orders',        'guard_name' => 'web', 'parent_id' => '68' ],
            ['id' => 204, 'name' => 'cancel-dispatch',                    'guard_name' => 'web', 'parent_id' => '74' ],

            // Note: ID 205 'administration' removed - duplicate of ID 8
            ['id' => 206, 'name' => 'Settings',                           'guard_name' => 'web', 'parent_id' => NULL ],
            ['id' => 207, 'name' => 'User Management',                    'guard_name' => 'web', 'parent_id' => '206'],
            ['id' => 208, 'name' => 'Menus',                              'guard_name' => 'web', 'parent_id' => '206'],
            ['id' => 209, 'name' => 'Role Management',                    'guard_name' => 'web', 'parent_id' => '206'],
            ['id' => 210, 'name' => 'create-Requisitions',                'guard_name' => 'web', 'parent_id' => '71' ],
            ['id' => 211, 'name' => 'Login Logs',                         'guard_name' => 'web', 'parent_id' => '206'],
            ['id' => 212, 'name' => 'Head Office Dashboard',              'guard_name' => 'web', 'parent_id' => '1'  ],
            ['id' => 213, 'name' => 'create_branch_targets',              'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 214, 'name' => 'create_tax_settings',                'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 215, 'name' => 'delete_branch_targets',              'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 216, 'name' => 'delete_tax_settings',                'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 217, 'name' => 'view_branch_targets',                'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 218, 'name' => 'view_tax_settings',                  'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 219, 'name' => 'edit_branch_targets',                'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 220, 'name' => 'edit_tax_settings',                  'guard_name' => 'web', 'parent_id' => '46' ],
            ['id' => 221, 'name' => 'hide_users',                         'guard_name' => 'web', 'parent_id' => '207'],
            ['id' => 222, 'name' => 'Leave Policies',                     'guard_name' => 'web', 'parent_id' => '126'],
            ['id' => 223, 'name' => 'advanced_settings',                  'guard_name' => 'web', 'parent_id' => '206'],
            ['id' => 224, 'name' => 'view_tn_unit_price',                 'guard_name' => 'web', 'parent_id' => '72' ],
            ['id' => 225, 'name' => 'view_tn_amount',                     'guard_name' => 'web', 'parent_id' => '72' ],
            ['id' => 226, 'name' => 'view_past_bookings',                 'guard_name' => 'web', 'parent_id' => '18' ],
            ['id' => 227, 'name' => 'Signed_Consent',                     'guard_name' => 'web', 'parent_id' => '34' ],
            ['id' => 228, 'name' => 'view_discount_users',                'guard_name' => 'web', 'parent_id' => '51' ],
            ['id' => 229, 'name' => 'add_discount_users',                 'guard_name' => 'web', 'parent_id' => '51' ],
            ['id' => 230, 'name' => 'edit_discount_users',                'guard_name' => 'web', 'parent_id' => '51' ],
            ['id' => 231, 'name' => 'add_discount_reasons',               'guard_name' => 'web', 'parent_id' => '51' ],
            ['id' => 232, 'name' => 'edit_discount_reasons',              'guard_name' => 'web', 'parent_id' => '51' ],
        ];
    }
}
