<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $map = $this->skedwiseRolePermissionMap();

        foreach ($map as $roleName => $permissions) {
            $role = Role::where('name', $roleName)->first();

            if (!$role) continue;
            $role->syncPermissions($this->resolvePermissions($permissions));
            
            $template_role = Role::where('name', 'Template_'.$roleName)->first();

            if(!$template_role) continue;
            $template_role->syncPermissions($this->resolvePermissions($permissions));
        }
    }

    public function skedwiseRolePermissionMap()
    {
        return [
            'Super User' => 'ALL',
            'Admin' => ['Head Office Dashboard', 'create-Requisitions', 'cancel-dispatch', 'add_payment-Purchase_Orders', 'return_GRN-Purchase_Orders', 'change_price-Purchase_Orders', 'change_price_grn-Purchase_Orders', 'view_grn-Purchase_Orders', 'create_grn-Purchase_Orders', 'edit-Purchase_Orders', 'create-Purchase_Orders', 'add-product_purchase_price', 'add-product_retail_price', 'edit-brand_product', 'create-brand_product', 'edit-brand', 'create-brand', 'create_invoice-Franchise_Orders', 'delete-Franchise_Orders', 'edit-Franchise_Orders', 'create-Franchise_Orders', 'edit-Franchise', 'create-Franchise', 'edit-Chart_Of_Accounts', 'create-Chart_Of_Accounts', 'User Management', 'Settings', 'Tickets', 'Online Orders', 'Orders', 'create-Bookings', 'delete-Account_Vouchers', 'view-Account_Vouchers', 'edit-Account_Vouchers', 'create-Account_Vouchers', 'view-customer', 'edit-customer', 'create-customer', 'edit-Visit', 'create-Visit', 'delete-Daily_Expenses', 'create-Daily_Expenses', 'add-Product_Orders', 'delete-Product_Orders', 'view-Product_Orders', 'Recover-Recovery_Invoices', 'Bad_Dept-Recovery_Invoices', 'view-Recovery_Invoices', 'Attendance', 'Close_Till', 'Cash_Register', 'Product_Categories_Status', 'Top_Retail_Customers', 'Month_Collection_Breakup', 'Category-wise_Stock_Sales_Analysis', 'Top_Products_Sales', 'Retail_Revenue', 'Unreceived_Goods', 'Retail_Advances', 'Retail_Receivable', 'mis_report-Other_Reports', 'mis_report-Invoices', 'mis_report-Staff', 'mis_report-Retail_&_Stock', 'mis_report-Service_Sales', 'mis_report-Appointments', 'Yearly_Sale_Comparison', 'Top_Customers', 'Top_Performing_Staff', 'Monthly_Performance', 'Footfall_Heatmap', 'Top_Service_Categories', 'Customer_Satisfaction', 'Repeat_Customers', 'Total_Revenue', 'Total_Invoiced_Visits', 'Retail Dashboard', 'Staff_Loan_&_Advance_Types', 'Staff_Allowances', 'Deduction_Policies', 'Mark_Gazetted_Holidays', 'HR_Setup', 'Staff_Deductions_Report', 'Staff_Provident_Fund', 'Yearly_Attendance_Report', 'Staff_Attendance_Report', 'Reports_&_Lists', 'Staff_Loan_Report', 'Staff_Loan_Approval', 'Staff_Loan_Applications', 'Loan_&_Advances', 'Staff_Leave_Report', 'Staff_Leave_Approval', 'Staff_Leave_Applications', 'Leave_Management', 'Staff_Loans_&_Advances', 'Staff_Payment_Slip_Generation', 'Staff_Payments', 'Staff_Payable_Voucher_Calculator', 'Pay-Roll_Management', 'Attendance_Requests', 'Staff_Management', 'Franchise_Product_Sale_Detail', 'Franchise_Aging', 'Franchise_Orders', 'Franchise', 'Branch_Ledger', 'Franchise_Ledger', 'Staff_Ledger', 'Customer_Ledger', 'Ledgers', 'Aging_Payables', 'Aging_Receivables', 'Reports', 'Fiscal_Year_Closing_History', 'Fiscal_Year_Closing', 'Profit_&_Loss', 'Balance_Sheet', 'Trial_Movement', 'Trial_Balance', 'Financial_Statements', 'General_Ledger', 'Account_Vouchers', 'Chart_Of_Accounts', 'Compiled_Kits', 'Return_Notes', 'Adjustment_Notes', 'Dispatch_Notes', 'Supplier_Ledger', 'Purchase_Reports', 'Reports_&_Notes', 'Direct_Dispatches', 'Dispatch_Requests', 'Dispatches', 'Transfer_Notes', 'Requisitions', 'Branch_Transfers', 'Receiving_Notes', 'Purchase_Orders', 'Purchases', 'Supplier_Management', 'Stock_Management', 'Products', 'Brands', 'Inventory_Management', 'Franchises', 'Gift_Vouchers', 'Records_&_Lists', 'Scheduled_Tasks', 'SMS_Log', 'Custom_SMS', 'SMS_Setup', 'Staff_Block_Time_Reasons', 'Staff_Listing', 'Flexi-Pricing', 'Discount_Configuration', 'Service_Floors', 'Service_Departments', 'Stores', 'Cities_/_Areas', 'Branch_Details', 'Branch_Setting', 'Packages_List', 'Services_List', 'Deal_Packages', 'Type_/_Category_/_Service', 'Services', 'Customers', 'Consultation_Notes', 'Color_Records', 'Facial_Records', 'Eye_Lash_Records', 'Customer_Records', 'POS_Service', 'POS_Retail', 'Dispatch', 'Un_Invoiced_Visits', 'Product_List', 'Price_List', 'Store_&_POS', 'Agent_Wise_Bookings', 'Period_Bookings', 'Staff_Performace', 'Service_Lapse_(Days)', 'Staff_Day_Business', 'Daily_Summary', 'Daily_Sheet', 'Daily_Sheets_&_Reports', 'Bookings', 'Appointments', 'Daily_Expenses', 'Product_Orders', 'Recovery_Invoices', 'Todays_Vouchers', 'Todays_Invoices', 'MISReports', 'SaaS_Dashboard', 'Services_Dashboard', 'HR_Management', 'Accounting', 'Procurement', 'My_Business', 'Reception', 'Scheduler', 'Dashboards', 'view_tn_unit_price', 'view_tn_amount', 'view_past_bookings'],
            'Reception' => ['Orders', 'create-Bookings', 'edit-Visit', 'create-Visit', 'delete-Daily_Expenses', 'create-Daily_Expenses', 'Recover-Recovery_Invoices', 'Bad_Dept-Recovery_Invoices', 'view-Recovery_Invoices', 'Attendance', 'Close_Till', 'Cash_Register', 'Consultation_Notes', 'Color_Records', 'Facial_Records', 'Eye_Lash_Records', 'Customer_Records', 'POS_Service', 'POS_Retail', 'Dispatch', 'Un_Invoiced_Visits', 'Product_List', 'Price_List', 'Store_&_POS', 'Agent_Wise_Bookings', 'Period_Bookings', 'Staff_Performace', 'Service_Lapse_(Days)', 'Staff_Day_Business', 'Daily_Summary', 'Daily_Sheet', 'Daily_Sheets_&_Reports', 'Bookings', 'Appointments', 'Daily_Expenses', 'Recovery_Invoices', 'Todays_Vouchers', 'Todays_Invoices', 'Reception', 'Scheduler'],
            'Store Manager' => ['create-Requisitions', 'cancel-dispatch', 'add_payment-Purchase_Orders', 'return_GRN-Purchase_Orders', 'change_price-Purchase_Orders', 'change_price_grn-Purchase_Orders', 'view_grn-Purchase_Orders', 'create_grn-Purchase_Orders', 'edit-Purchase_Orders', 'create-Purchase_Orders', 'add-product_purchase_price', 'add-product_retail_price', 'edit-brand_product', 'create-brand_product', 'edit-brand', 'create-brand', 'Tickets', 'view-customer', 'edit-customer', 'create-customer', 'Product_Categories_Status', 'Top_Retail_Customers', 'Month_Collection_Breakup', 'Category-wise_Stock_Sales_Analysis', 'Top_Products_Sales', 'Retail_Revenue', 'Unreceived_Goods', 'Retail_Advances', 'Retail_Receivable', 'mis_report-Other_Reports', 'mis_report-Invoices', 'mis_report-Staff', 'mis_report-Retail_&_Stock', 'Retail Dashboard', 'Compiled_Kits', 'Return_Notes', 'Adjustment_Notes', 'Dispatch_Notes', 'Supplier_Ledger', 'Purchase_Reports', 'Reports_&_Notes', 'Direct_Dispatches', 'Dispatch_Requests', 'Dispatches', 'Transfer_Notes', 'Requisitions', 'Branch_Transfers', 'Receiving_Notes', 'Purchase_Orders', 'Purchases', 'Supplier_Management', 'Stock_Management', 'Products', 'Brands', 'Inventory_Management', 'Franchises', 'Gift_Vouchers', 'Records_&_Lists', 'Staff_Block_Time_Reasons', 'Staff_Listing', 'Flexi-Pricing', 'Discount_Configuration', 'Service_Floors', 'Service_Departments', 'Stores', 'Cities_/_Areas', 'Branch_Details', 'Branch_Setting', 'Packages_List', 'Services_List', 'Deal_Packages', 'Type_/_Category_/_Service', 'Services', 'Customers', 'MISReports', 'Procurement', 'My_Business', 'Dashboards'],
            'HR' => ['mis_report-Other_Reports', 'mis_report-Invoices', 'mis_report-Staff', 'mis_report-Retail_&_Stock', 'mis_report-Service_Sales', 'mis_report-Appointments', 'Staff_Loan_&_Advance_Types', 'Staff_Allowances', 'Deduction_Policies', 'Mark_Gazetted_Holidays', 'HR_Setup', 'Staff_Deductions_Report', 'Staff_Provident_Fund', 'Yearly_Attendance_Report', 'Staff_Attendance_Report', 'Reports_&_Lists', 'Staff_Loan_Report', 'Staff_Loan_Approval', 'Staff_Loan_Applications', 'Loan_&_Advances', 'Staff_Leave_Report', 'Staff_Leave_Approval', 'Staff_Leave_Applications', 'Leave_Management', 'Staff_Loans_&_Advances', 'Staff_Payment_Slip_Generation', 'Staff_Payments', 'Staff_Payable_Voucher_Calculator', 'Pay-Roll_Management', 'Attendance_Requests', 'Staff_Management', 'Staff_Block_Time_Reasons', 'Staff_Listing', 'Branch_Setting', 'MISReports', 'HR_Management'],
            'Board' => [],
            'Accountant' => ['Head Office Dashboard', 'edit-Chart_Of_Accounts', 'create-Chart_Of_Accounts', 'delete-Account_Vouchers', 'view-Account_Vouchers', 'edit-Account_Vouchers', 'create-Account_Vouchers', 'Product_Categories_Status', 'Top_Retail_Customers', 'Month_Collection_Breakup', 'Category-wise_Stock_Sales_Analysis', 'Top_Products_Sales', 'Retail_Revenue', 'Unreceived_Goods', 'Retail_Advances', 'Retail_Receivable', 'mis_report-Other_Reports', 'mis_report-Invoices', 'mis_report-Staff', 'mis_report-Retail_&_Stock', 'mis_report-Service_Sales', 'mis_report-Appointments', 'Yearly_Sale_Comparison', 'Top_Customers', 'Top_Performing_Staff', 'Monthly_Performance', 'Footfall_Heatmap', 'Top_Service_Categories', 'Customer_Satisfaction', 'Repeat_Customers', 'Total_Revenue', 'Total_Invoiced_Visits', 'Retail Dashboard', 'Branch_Ledger', 'Franchise_Ledger', 'Staff_Ledger', 'Customer_Ledger', 'Ledgers', 'Aging_Payables', 'Aging_Receivables', 'Reports', 'Fiscal_Year_Closing_History', 'Fiscal_Year_Closing', 'Profit_&_Loss', 'Balance_Sheet', 'Trial_Movement', 'Trial_Balance', 'Financial_Statements', 'General_Ledger', 'Account_Vouchers', 'Chart_Of_Accounts', 'MISReports', 'SaaS_Dashboard', 'Services_Dashboard', 'Accounting', 'Dashboards'],
            'Trainer' => [],
            'HO' => ['Head Office Dashboard', 'create-Requisitions', 'cancel-dispatch', 'add_payment-Purchase_Orders', 'return_GRN-Purchase_Orders', 'change_price-Purchase_Orders', 'change_price_grn-Purchase_Orders', 'view_grn-Purchase_Orders', 'create_grn-Purchase_Orders', 'edit-Purchase_Orders', 'create-Purchase_Orders', 'add-product_purchase_price', 'add-product_retail_price', 'edit-brand_product', 'create-brand_product', 'edit-brand', 'create-brand', 'create_invoice-Franchise_Orders', 'delete-Franchise_Orders', 'edit-Franchise_Orders', 'create-Franchise_Orders', 'edit-Franchise', 'create-Franchise', 'edit-Chart_Of_Accounts', 'create-Chart_Of_Accounts', 'User Management', 'Settings', 'Tickets', 'Online Orders', 'Orders', 'create-Bookings', 'delete-Account_Vouchers', 'view-Account_Vouchers', 'edit-Account_Vouchers', 'create-Account_Vouchers', 'view-customer', 'edit-customer', 'create-customer', 'edit-Visit', 'create-Visit', 'delete-Daily_Expenses', 'create-Daily_Expenses', 'add-Product_Orders', 'delete-Product_Orders', 'view-Product_Orders', 'Recover-Recovery_Invoices', 'Bad_Dept-Recovery_Invoices', 'view-Recovery_Invoices', 'Attendance', 'Close_Till', 'Cash_Register', 'Product_Categories_Status', 'Top_Retail_Customers', 'Month_Collection_Breakup', 'Category-wise_Stock_Sales_Analysis', 'Top_Products_Sales', 'Retail_Revenue', 'Unreceived_Goods', 'Retail_Advances', 'Retail_Receivable', 'mis_report-Other_Reports', 'mis_report-Invoices', 'mis_report-Staff', 'mis_report-Retail_&_Stock', 'mis_report-Service_Sales', 'mis_report-Appointments', 'Yearly_Sale_Comparison', 'Top_Customers', 'Top_Performing_Staff', 'Monthly_Performance', 'Footfall_Heatmap', 'Top_Service_Categories', 'Customer_Satisfaction', 'Repeat_Customers', 'Total_Revenue', 'Total_Invoiced_Visits', 'Retail Dashboard', 'Staff_Loan_&_Advance_Types', 'Staff_Allowances', 'Deduction_Policies', 'Mark_Gazetted_Holidays', 'HR_Setup', 'Staff_Deductions_Report', 'Staff_Provident_Fund', 'Yearly_Attendance_Report', 'Staff_Attendance_Report', 'Reports_&_Lists', 'Staff_Loan_Report', 'Staff_Loan_Approval', 'Staff_Loan_Applications', 'Loan_&_Advances', 'Staff_Leave_Report', 'Staff_Leave_Approval', 'Staff_Leave_Applications', 'Leave_Management', 'Staff_Loans_&_Advances', 'Staff_Payment_Slip_Generation', 'Staff_Payments', 'Staff_Payable_Voucher_Calculator', 'Pay-Roll_Management', 'Attendance_Requests', 'Staff_Management', 'Franchise_Product_Sale_Detail', 'Franchise_Aging', 'Franchise_Orders', 'Franchise', 'Branch_Ledger', 'Franchise_Ledger', 'Staff_Ledger', 'Customer_Ledger', 'Ledgers', 'Aging_Payables', 'Aging_Receivables', 'Reports', 'Fiscal_Year_Closing_History', 'Fiscal_Year_Closing', 'Profit_&_Loss', 'Balance_Sheet', 'Trial_Movement', 'Trial_Balance', 'Financial_Statements', 'General_Ledger', 'Account_Vouchers', 'Chart_Of_Accounts', 'Compiled_Kits', 'Return_Notes', 'Adjustment_Notes', 'Dispatch_Notes', 'Supplier_Ledger', 'Purchase_Reports', 'Reports_&_Notes', 'Direct_Dispatches', 'Dispatch_Requests', 'Dispatches', 'Transfer_Notes', 'Requisitions', 'Branch_Transfers', 'Receiving_Notes', 'Purchase_Orders', 'Purchases', 'Supplier_Management', 'Stock_Management', 'Products', 'Brands', 'Inventory_Management', 'Franchises', 'Gift_Vouchers', 'Records_&_Lists', 'Scheduled_Tasks', 'SMS_Log', 'Custom_SMS', 'SMS_Setup', 'Staff_Block_Time_Reasons', 'Staff_Listing', 'Flexi-Pricing', 'Discount_Configuration', 'Service_Floors', 'Service_Departments', 'Stores', 'Cities_/_Areas', 'Branch_Details', 'Branch_Setting', 'Packages_List', 'Services_List', 'Deal_Packages', 'Type_/_Category_/_Service', 'Services', 'Customers', 'Consultation_Notes', 'Color_Records', 'Facial_Records', 'Eye_Lash_Records', 'Customer_Records', 'POS_Service', 'POS_Retail', 'Dispatch', 'Un_Invoiced_Visits', 'Product_List', 'Price_List', 'Store_&_POS', 'Agent_Wise_Bookings', 'Period_Bookings', 'Staff_Performace', 'Service_Lapse_(Days)', 'Staff_Day_Business', 'Daily_Summary', 'Daily_Sheet', 'Daily_Sheets_&_Reports', 'Bookings', 'Appointments', 'Daily_Expenses', 'Product_Orders', 'Recovery_Invoices', 'Todays_Vouchers', 'Todays_Invoices', 'MISReports', 'SaaS_Dashboard', 'Services_Dashboard', 'HR_Management', 'Accounting', 'Procurement', 'My_Business', 'Reception', 'Scheduler', 'Dashboards'],
            'Feedback' => [],
            'Sh-Users' => [],
            'Floor Staff' => [],
            'Store Operator' => ['create-Requisitions', 'create_invoice-Franchise_Orders', 'delete-Franchise_Orders', 'Dispatch_Notes', 'Reports_&_Notes', 'Direct_Dispatches', 'Dispatch_Requests', 'Dispatches', 'Requisitions', 'Products', 'Brands', 'Procurement'],
            'Call Center Op' => [],
            'Attendance' => [],
            'Manual Attendance' => [],
            'ResPOS' => [],
            'Restaurant Admin' => [],
            'Franchise Manager' => [],
            'Super Admin' => ['Leave Policies', 'create_branch_targets', 'delete_branch_targets', 'edit_branch_targets', 'view_branch_targets', 'delete_tax_settings', 'edit_tax_settings', 'create_tax_settings', 'view_tax_settings', 'Head Office Dashboard', 'Login Logs', 'create-Requisitions', 'cancel-dispatch', 'add_payment-Purchase_Orders', 'return_GRN-Purchase_Orders', 'change_price-Purchase_Orders', 'change_price_grn-Purchase_Orders', 'view_grn-Purchase_Orders', 'create_grn-Purchase_Orders', 'edit-Purchase_Orders', 'create-Purchase_Orders', 'add-product_purchase_price', 'add-product_retail_price', 'edit-brand_product', 'create-brand_product', 'edit-brand', 'create-brand', 'create_invoice-Franchise_Orders', 'delete-Franchise_Orders', 'edit-Franchise_Orders', 'create-Franchise_Orders', 'edit-Franchise', 'create-Franchise', 'edit-Chart_Of_Accounts', 'create-Chart_Of_Accounts', 'User Management', 'Settings', 'Tickets', 'Online Orders', 'Orders', 'create-Bookings', 'delete-Account_Vouchers', 'view-Account_Vouchers', 'edit-Account_Vouchers', 'create-Account_Vouchers', 'view-customer', 'edit-customer', 'create-customer', 'edit-Visit', 'create-Visit', 'delete-Daily_Expenses', 'create-Daily_Expenses', 'add-Product_Orders', 'delete-Product_Orders', 'view-Product_Orders', 'Recover-Recovery_Invoices', 'Bad_Dept-Recovery_Invoices', 'view-Recovery_Invoices', 'Attendance', 'Close_Till', 'Cash_Register', 'Product_Categories_Status', 'Top_Retail_Customers', 'Month_Collection_Breakup', 'Category-wise_Stock_Sales_Analysis', 'Top_Products_Sales', 'Retail_Revenue', 'Unreceived_Goods', 'Retail_Advances', 'Retail_Receivable', 'mis_report-Other_Reports', 'mis_report-Invoices', 'mis_report-Staff', 'mis_report-Retail_&_Stock', 'mis_report-Service_Sales', 'mis_report-Appointments', 'Yearly_Sale_Comparison', 'Top_Customers', 'Top_Performing_Staff', 'Monthly_Performance', 'Footfall_Heatmap', 'Top_Service_Categories', 'Customer_Satisfaction', 'Repeat_Customers', 'Total_Revenue', 'Total_Invoiced_Visits', 'Retail Dashboard', 'Staff_Loan_&_Advance_Types', 'Staff_Allowances', 'Deduction_Policies', 'Mark_Gazetted_Holidays', 'HR_Setup', 'Staff_Deductions_Report', 'Staff_Provident_Fund', 'Yearly_Attendance_Report', 'Staff_Attendance_Report', 'Reports_&_Lists', 'Staff_Loan_Report', 'Staff_Loan_Approval', 'Staff_Loan_Applications', 'Loan_&_Advances', 'Staff_Leave_Report', 'Staff_Leave_Approval', 'Staff_Leave_Applications', 'Leave_Management', 'Staff_Loans_&_Advances', 'Staff_Payment_Slip_Generation', 'Staff_Payments', 'Staff_Payable_Voucher_Calculator', 'Pay-Roll_Management', 'Attendance_Requests', 'Staff_Management', 'Franchise_Product_Sale_Detail', 'Franchise_Aging', 'Franchise_Orders', 'Franchise', 'Branch_Ledger', 'Franchise_Ledger', 'Staff_Ledger', 'Customer_Ledger', 'Ledgers', 'Aging_Payables', 'Aging_Receivables', 'Reports', 'Fiscal_Year_Closing_History', 'Fiscal_Year_Closing', 'Profit_&_Loss', 'Balance_Sheet', 'Trial_Movement', 'Trial_Balance', 'Financial_Statements', 'General_Ledger', 'Account_Vouchers', 'Chart_Of_Accounts', 'Compiled_Kits', 'Return_Notes', 'Adjustment_Notes', 'Dispatch_Notes', 'Supplier_Ledger', 'Purchase_Reports', 'Reports_&_Notes', 'Direct_Dispatches', 'Dispatch_Requests', 'Dispatches', 'Transfer_Notes', 'Requisitions', 'Branch_Transfers', 'Receiving_Notes', 'Purchase_Orders', 'Purchases', 'Supplier_Management', 'Stock_Management', 'Products', 'Brands', 'Inventory_Management', 'Franchises', 'Gift_Vouchers', 'Records_&_Lists', 'Scheduled_Tasks', 'SMS_Log', 'Custom_SMS', 'SMS_Setup', 'Staff_Block_Time_Reasons', 'Staff_Listing', 'Flexi-Pricing', 'Discount_Configuration', 'Service_Floors', 'Service_Departments', 'Stores', 'Cities_/_Areas', 'Branch_Details', 'Branch_Setting', 'Packages_List', 'Services_List', 'Deal_Packages', 'Type_/_Category_/_Service', 'Services', 'Customers', 'Consultation_Notes', 'Color_Records', 'Facial_Records', 'Eye_Lash_Records', 'Customer_Records', 'POS_Service', 'POS_Retail', 'Dispatch', 'Un_Invoiced_Visits', 'Product_List', 'Price_List', 'Store_&_POS', 'Agent_Wise_Bookings', 'Period_Bookings', 'Staff_Performace', 'Service_Lapse_(Days)', 'Staff_Day_Business', 'Daily_Summary', 'Daily_Sheet', 'Daily_Sheets_&_Reports', 'Bookings', 'Appointments', 'Daily_Expenses', 'Product_Orders', 'Recovery_Invoices', 'Todays_Vouchers', 'Todays_Invoices', 'MISReports', 'SaaS_Dashboard', 'Services_Dashboard', 'HR_Management', 'Accounting', 'Procurement', 'My_Business', 'Reception', 'Scheduler', 'Dashboards', 'view_tn_unit_price', 'view_tn_amount', 'view_past_bookings'],
        ];
    }

    private function resolvePermissions($value)
    {
        if ($value === 'ALL') {
            return Permission::all();
        }

        return Permission::whereIn('name', $value)->get();
    }


}
