<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RolesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $skedwise_roles = $this->skedwiseRoles();

        Role::insert($skedwise_roles);

        foreach ($skedwise_roles as $role) {
            Role::updateOrCreate(
    [
                    'name' => 'Template_'.$role['name'],
                    'guard_name' => $role['guard_name'],
                ],
        [
                    'role_desc' => $role['role_desc'] ?? null,
                    'is_template' => 1,
                ]
            );
        }
    }

    public function skedwiseRoles()
    {
        return [
            ['name' => 'Admin', 'role_desc' => "Administration", 'guard_name' => 'web'],
            ['name' => 'Reception', 'role_desc' => "Receptionist hanlding visits and Appointments", 'guard_name' => 'web'],
            ['name' => 'Store Manager', 'role_desc' => '(users of this role will see only the (type/category/service), (bands/products), (suppliers), (vouchers) and (color types) in "My Business" menu and the complete procurement menu item', 'guard_name' => 'web'],
            ['name' => 'HR', 'role_desc' => "(users of this role will see everything related to staff such as staff add edit etc. and reports showing staff performance such as retail by staff or services provided by staff or staff attendance", 'guard_name' => 'web'],
            ['name' => 'Board', 'role_desc' => "Can only view the board, Time in and Time out are allowed", 'guard_name' => 'web'],
            ['name' => 'Accountant', 'role_desc' => "", 'guard_name' => 'web'],
            ['name' => 'Super User', 'role_desc' => "", 'guard_name' => 'web'],
            ['name' => 'Trainer', 'role_desc' => "", 'guard_name' => 'web'],
            ['name' => 'HO', 'role_desc' => "", 'guard_name' => 'web'],
            ['name' => 'Feedback', 'role_desc' => "Login only to get feedback from customers", 'guard_name' => 'web'],
            ['name' => 'Sh-Users', 'role_desc' => "Shadow", 'guard_name' => 'web'],
            ['name' => 'Floor Staff', 'role_desc' => "Can only add services on Scheduler", 'guard_name' => 'web'],
            ['name' => 'Store Operator', 'role_desc' => "(users of this role will see only see procurement)", 'guard_name' => 'web'],
            ['name' => 'Call Center Op', 'role_desc' => "", 'guard_name' => 'web'],
            ['name' => 'Attendance', 'role_desc' => "", 'guard_name' => 'web'],
            ['name' => 'Manual Attendance', 'role_desc' => "", 'guard_name' => 'web'],
            ['name' => 'ResPOS', 'role_desc' => "Can only work on restaurant POS", 'guard_name' => 'web'],
            ['name' => 'Restaurant Admin', 'role_desc' => "Administration of Restaurant", 'guard_name' => 'web'],
            ['name' => 'Franchise Manager', 'role_desc' => "Only uses franchise module", 'guard_name' => 'web'],
            ['name' => 'Super Admin', 'role_desc' => "", 'guard_name' => 'web'],
        ];
    }
}
