/**
 * Theme: SkedWise - Responsive Bootstrap 5 Admin Dashboard
 * Author: Mexyon
 * Module/App: Data tables
 */


// import  'bootstrap/dist/js/bootstrap.bundle'


import 'datatables.net-bs5/css/dataTables.bootstrap5.min.css';
import 'datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css';
import 'datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css';

import 'datatables.net';
import 'datatables.net-bs5';
import 'datatables.net-responsive';
import 'datatables.net-responsive-bs5';
import 'datatables.net-fixedcolumns-bs5';
import 'datatables.net-fixedheader';
import 'datatables.net-bs5';
import 'datatables.net-buttons-bs5';
import 'datatables.net-buttons/js/buttons.html5'; // For CSV, Excel
import 'datatables.net-buttons/js/buttons.print';

import 'datatables.net-buttons/js/buttons.print.min.js';
import 'datatables.net-keytable/js/dataTables.keyTable';
import 'datatables.net-select/js/dataTables.select';



$(function () {
    "use strict";


    
    // Default Datatable
    $('#basic-datatable').DataTable({
        keys: true,
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        }
    });

    //Buttons examples
    var table = $('#datatable-buttons').DataTable({
        lengthChange: false,
        stateSave: true,
        fixedHeader: true,        
        buttons: ['copy', 'print'],
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "layout": {
            topStart: "buttons"
        },
       buttons: [
            { extend: "copy",  className: "btn btn-sm btn-warning active" },
            { extend: "csv",   className: "btn btn-sm btn-warning" },
            { extend: "print", className: "btn btn-sm btn-warning" },
            { extend: "pdf", className: "btn btn-sm btn-warning" }
        ],
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        }
    });

   
   
    // Multi Selection Datatable
    $('#selection-datatable').DataTable({
        select: {
            style: 'multi'
        },
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        }
    });

    table.buttons().container()
        .appendTo('#datatable-buttons_wrapper .col-md-6:eq(0)');


    // Alternative Pagination Datatable
    $('#alternative-page-datatable').DataTable({
        "pagingType": "full_numbers",
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        }
    });

    // Scroll Vertical Datatable
    $('#scroll-vertical-datatable').DataTable({
        "scrollY": "350px",
        "scrollCollapse": true,
        "paging": false,
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        }
    });

    // Scroll Vertical Datatable
    $('#scroll-horizontal-datatable').DataTable({
        "scrollX": true,
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        }
    });

    // Complex headers with column visibility Datatable
    $('#complex-header-datatable').DataTable({
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        },
        "columnDefs": [{
            "visible": false,
            "targets": -1
        }]
    });

    // Row created callback Datatable
    $('#row-callback-datatable').DataTable({
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        },
        "createdRow": function (row, data, index) {
            if (data[5].replace(/[\$,]/g, '') * 1 > 150000) {
                $('td', row).eq(5).addClass('text-danger');
            }
        }
    });

    // State Saving Datatable
    $('#state-saving-datatable').DataTable({
        stateSave: true,
        "language": {
            "paginate": {
                "previous": "<i class='ti ti-chevron-left'>",
                "next": "<i class='ti ti-chevron-right'>"
            }
        },
        "drawCallback": function () {
            $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
        }
    });

    // Fixed header Datatable
    $('#fixed-header-datatable').DataTable({
        fixedHeader: true,
    });

    // Fixed Columns Datatable
    $('#fixed-columns-datatable').DataTable({
        scrollY: 300,
        scrollX: true,
        scrollCollapse: true,
        paging: false,
        fixedColumns: true
    });

    $(".dataTables_length select").addClass('form-select form-select-sm');
    $(".dataTables_length label").addClass('form-label');

});
