
    $(function() {
        

        // Generate a unique ID for the current tab
        const tabId = Math.random().toString(36).substring(2);

        // Store the tab ID in localStorage
        localStorage.setItem(`sked-${tabId}`, 'open');

        // Clean up when the tab is closed
        window.addEventListener('beforeunload', () => {
            localStorage.removeItem(`sked-${tabId}`);
        });
        
        window.onunload = function () {
            Cookies.set('tabs', + Cookies.get('tabs') - 1);
        };

        // <?php if(null != session('user_id')) { ?>
        // Set the Global reset counter variable
        var resetCounter = 0;

        // Set the interval for the reset function
        setInterval(function() {
            resetCounter++;
            if (resetCounter >= 60) { // Reset every 60 seconds
                console.log('Resetting global state after 3 minutes and logging out');                
               // Logout of the current session
               resetCounter = 0; // Reset the counter
                window.location.href = "{{ route('logout') }}";
                
            }
        }, 600000); // Check every three minutes

        $('html').on("click" , function(event){
            resetGlobal();
        });
        
        $('html').on("keyup", function(event){
            resetGlobal();                    
        });

        $('html').on("keydown", function(event){
            resetGlobal();
        });

        $('html').on("mousemove", function(event){
            resetGlobal();
        });
        // <?php } ?>
        // Uncomment the following lines if you want to use these functions
        //getCustomerBirthdays();        
        //checkpayment();
        
        $(".alpha").on("keypress", function(e) {
            // console.log(e.which);
            //stop character if not a letter or control key
            if (e.which != 13 && e.which != 8 && e.which != 0 && e.which != 32 && (e.which < 65 || e.which > 90) && (e.which < 97 || e.which > 122)) {
                return false;
            }
        });

        $(".numeric").on("keypress", function (e) {
            //stop character if not a digit or control key
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && (e.which < 48 || e.which > 57)) {
               return false;
           }
        });
        
        $(".multinumeric").on("keypress", function (e) {
            //stop character if not a digit, comma, period or control key
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && e.which != 44 && (e.which < 48 || e.which > 57)) {
               return false;
           }
        });

        $(".decimal").on("keypress", function(e) {
            //stop character if not a digit, period or control key
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && (e.which < 48 || e.which > 57) ) {

                return false;
            }
        });
        
    });

    function b_switch(){
            // Check for other open tabs
        const openTabs = Object.keys(localStorage).filter(key => key.startsWith('sked-'));
        if (openTabs.length > 1) {
            console.log('More than one tab is open.');
            Swal({
                title: 'Close All Other Tabs',
                text: 'You cannot switch if more then one tabs are open!',
                type: 'error',
                confirmButtonText: 'OK!'
            }); 
            return false;
        } else {
            // console.log('This is the only tab open.');
        }

        var businessId = $('#business-meta').data('business-id');
        var token = $('#business-meta').data('token');
        var ajaxUrl = $('#ajax-business-url').data('url');
        $.ajax({
            type: 'POST',
            url: ajaxUrl,
            data: {
                business_id: businessId,
                _token: token,
                openagain: 1
            },
                        dataType: "json",
            cache: false,
            async: true,
            success: function(data) {
                // console.log(data.length)
                $("#modalbusinesslist").html('');
                if(data.length > 0){
                    var chtml ='';
                    for(x=0; x<data.length;x++){
                        chtml+='<li onclick="submit_business('+data[x]['id_business']+',\''+data[x]['business_name']+'\',\''+data[x]['ho']+'\',\''+data[x]['common_products']+'\',\''+data[x]['common_services']+'\',\''+data[x]['business_type']+'\');"><img src="{{ asset('images/business/') }} ' + data[x]['business_logo'] + '" alt=""><span class="business_name">'+ data[x]['business_name'].trim() +'</span></li>';
                    }
                    //console.log(chtml);
                    $("#modalbusinesslist").html(chtml);
                    $("#businessmodal").modal("show");
                    // Initialize List.js for search functionality
                        var options = {
                            valueNames: ['business_name']
                        };
                        var businessList = new List('pick-business-div', options);
                }
            }
        });
    }
    
    function submit_business(id_business, business_name, business_ho){
        
        $('#id_business').val(id_business);
        $('#business_name').val(business_name);
        $('#business_ho').val(business_ho);
        $("#openagain").submit();
    }

    function resetGlobal() {
        // Reset any global variables or states here
        console.log('Global state reset');

        resetCounter = 0; // Reset the counter

    }