
        import $, { get } from 'jquery';
 
         // Cash Register Modal show event
        document.getElementById('cash_register_modal')
            .addEventListener('show.bs.modal', function (event) { 
               //Disable Save Button and show spinner
               $("#saveCashRegisterBtn").prop("disabled", true);
               $("#saveCashRegisterSpinner").removeClass("d-none");

               getCashRegisterData();

            });

        window.getCashRegisterData = (() => {    
            fetch(baseURL + "/getCashRegister", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                },
                body: JSON.stringify({
                    //remove time portion from datetime
                    //cash_register_date: $('#lastupdatedate').val().split(' ')[0]
                    cash_register_date: $("#calendardate").val().split('T')[0]
                })
            }).then(response => response.json())
              .then(data => {
                  if (data.res_type === 'success') {
                    //Enable Save Button and hide spinner
                    $("#saveCashRegisterBtn").prop("disabled", false);
                    $("#saveCashRegisterSpinner").addClass("d-none");

                    //set print button href
                    let printUrl = baseURL + "/cash_register_print/" + $("#calendardate").val().split('T')[0];
                    document.getElementById('cashRegisterPrintButton').setAttribute('href', printUrl);

                    //console.log(data.cash_register_date);
                      // Populate the modal with the cash register data
                    //format date to dd-mm-yyyy
                    let formattedDate = new Date(data.cash_register_date).toLocaleDateString('en-GB');
                    document.getElementById('cashRegDate').textContent = formattedDate;
                    document.getElementById('cashRegisterBusinessName').textContent = data.business_name;

                    let total_collection = 0; let net_collection = 0; let total_payment = 0;
                    let cash_in_hand = 0; let final_cash = 0;
                    data.invoice_data.forEach(function(value) {
                        //Collections Credit
                        document.querySelectorAll('[data-ds-entity="grosstotal_service_credit"]').forEach(el => {
                            if(value.entity == "grosstotal_service") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                total_collection += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="grosstotal_retail_credit"]').forEach(el => {
                            if(value.entity == "grosstotal_retail") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                total_collection += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="grosstotal_voucher_credit"]').forEach(el => {
                            if(value.entity == "grosstotal_voucher") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                total_collection += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="grosstotal_training_credit"]').forEach(el => {
                            if(value.entity == "grosstotal_training") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                total_collection += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="advance_adjusted_credit"]').forEach(el => {
                            if(value.entity == "advance_adjusted") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                total_collection += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="retained_amount_credit"]').forEach(el => {
                            if(value.entity == "retained_amount") { 
                                el.textContent = parseFloat(value.credit).toFixed(2); 
                                total_collection += parseFloat(value.credit);
                            }                             
                        });
                        document.querySelectorAll('[data-ds-entity="sales_tax_credit"]').forEach(el => {
                            if(value.entity == "sales_tax") { 
                                el.textContent = parseFloat(value.credit).toFixed(2); 
                                total_collection += parseFloat(value.credit);
                            }                             
                        });

                        //Debits
                        
                        document.querySelectorAll('[data-ds-entity="balance_debit"]').forEach(el => {
                            if(value.entity == "balance") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                net_collection -= parseFloat(value.debit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="advance_adjusted_debit"]').forEach(el => {
                            if(value.entity == "advance_adjusted") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                net_collection -= parseFloat(value.debit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="retained_amount_used_debit"]').forEach(el => {
                            if(value.entity == "retained_amount_used") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                net_collection -= parseFloat(value.debit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="receivable_credit"]').forEach(el => {
                            if(value.entity == "receivable") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                net_collection += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="cc_tip_credit"]').forEach(el => {
                            if(value.entity == "cc_tip") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                net_collection += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="cc_fee_credit"]').forEach(el => {
                            if(value.entity == "cc_fee") {
                                el.textContent = parseFloat(value.credit).toFixed(2);
                                net_collection += parseFloat(value.credit);
                            }
                        });
                        //payments
                        document.querySelectorAll('[data-ds-entity="paid_card"]').forEach(el => {
                            if(value.entity == "paid_card") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                total_payment += parseFloat(value.debit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="paid_check"]').forEach(el => {
                            if(value.entity == "paid_check") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                total_payment += parseFloat(value.debit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="paid_online"]').forEach(el => {
                            if(value.entity == "paid_online") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                total_payment += parseFloat(value.debit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="paid_voucher"]').forEach(el => {
                            if(value.entity == "paid_voucher") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                total_payment += parseFloat(value.debit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="paid_cash"]').forEach(el => {
                            if(value.entity == "paid_cash") {
                                el.textContent = parseFloat(value.debit).toFixed(2);
                                total_payment += parseFloat(value.debit);
                            }
                        });

                        //Cash reconciliation
                        document.querySelectorAll('[data-ds-entity="cash"]').forEach(el => {
                            if(value.entity == "paid_cash") {
                                el.textContent = parseFloat(value.debit).toFixed(2);                                
                                cash_in_hand += parseFloat(value.debit);
                            }
                        });

                        document.querySelectorAll('[data-ds-entity="paid_cash_credit"]').forEach(el => {
                            if(value.entity == "paid_cash") {
                                el.textContent = parseFloat(value.credit).toFixed(2);                                
                                final_cash += parseFloat(value.credit);
                            }
                        });
                        document.querySelectorAll('[data-ds-entity="cc_tip_less"]').forEach(el => {
                            if(value.entity == "cc_tip") {
                                el.textContent = parseFloat(value.credit).toFixed(2);                                
                                final_cash += parseFloat(value.credit);
                            }
                        });

                    });

                    
                    document.getElementById('totalSale').textContent = total_collection.toFixed(2);
                    document.getElementById('totalTransaction').textContent = (total_collection + net_collection).toFixed(2);
                    document.getElementById('totalPayments').textContent = total_payment.toFixed(2);
                    document.getElementById('CashFinal').textContent = cash_in_hand.toFixed(2);
                    document.getElementById('finalCashInRegister').textContent = (cash_in_hand - final_cash).toFixed(2);
                    document.getElementById('totalCash').textContent = (cash_in_hand - final_cash).toFixed(2);
                    
                    document.getElementById('dbformatdate').value = data.cash_register_date;
                    
                    //fill cash register denomination fields if cash register exists
                    let cash_register_data = data.cash_register_data;
                    if(cash_register_data){
                        if(cash_register_data.register_status === 'closed'){
                            $('#saveCashRegisterBtn').prop('disabled', true);
                            $('#btnCashRegisterReopen').prop('disabled', false);
                        } else {
                            $('#saveCashRegisterBtn').prop('disabled', false);
                            $('#btnCashRegisterReopen').prop('disabled', true);
                        }
                        
                        $('#5000input').val(cash_register_data.x5000);
                        $("#x5000").html((parseInt(cash_register_data.x5000) * 5000).toFixed(2));
                        $("#5000span").text(cash_register_data.x5000);
                        $('#1000input').val(cash_register_data.x1000);
                        $("#x1000").html((parseInt(cash_register_data.x1000) * 1000).toFixed(2));
                        $('#1000span').text(cash_register_data.x1000);
                        $('#500input').val(cash_register_data.x500);
                        $("#x500").html((parseInt(cash_register_data.x500) * 500).toFixed(2));
                        $('#500span').text(cash_register_data.x500);
                        $('#100input').val(cash_register_data.x100);
                        $("#x100").html((parseInt(cash_register_data.x100) * 100).toFixed(2));
                        $('#100span').text(cash_register_data.x100);
                        $('#75input').val(cash_register_data.x75);
                        $("#x75").html((parseInt(cash_register_data.x75) * 75).toFixed(2));
                        $('#75span').text(cash_register_data.x75);
                        $('#50input').val(cash_register_data.x50);
                        $("#x50").html((parseInt(cash_register_data.x50) * 50).toFixed(2));
                        $('#50span').text(cash_register_data.x50);
                        $('#20input').val(cash_register_data.x20);
                        $("#x20").html((parseInt(cash_register_data.x20) * 20).toFixed(2));
                        $('#20span').text(cash_register_data.x20);
                        $('#10input').val(cash_register_data.x10);
                        $("#x10").html((parseInt(cash_register_data.x10) * 10).toFixed(2));
                        $('#10span').text(cash_register_data.x10);
                        $('#5input').val(cash_register_data.x5);
                        $("#x5").html((parseInt(cash_register_data.x5) * 5).toFixed(2));
                        $('#5span').text(cash_register_data.x5);
                        $('#1input').val(cash_register_data.x1);
                        $("#x1").html((parseInt(cash_register_data.x1) * 1).toFixed(2));
                        $('#1span').text(cash_register_data.x1);
                        $('#cash_addition').val(cash_register_data.cash_addition);
                        $('#today_till').val(cash_register_data.till_amounts);
                        // $('#cash_difference').val(item.difference);
                        $('#cashRemarks').val(cash_register_data.remarks);
                        updateCashRegister($('#5000input'));
                    } else {
                        $('#saveCashRegisterBtn').prop('disabled', false);
                            $('#btnCashRegisterReopen').prop('disabled', true);
                    }
                  } else {
                      // Handle error
                      Swal.fire('Error', data.msg, 'error');
                  }
              });
            
    });

    // Cash Register Modal hidden event
        document.getElementById('cash_register_modal')
            .addEventListener('hidden.bs.modal', function (event) { 
                // Reset form fields
                document.getElementById('cashRegisterBusinessName').textContent = '';
                document.getElementById('cashRegDate').textContent = '';

                document.querySelectorAll('[data-ds-entity="grosstotal_service_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="grosstotal_retail_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="grosstotal_voucher_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="grosstotal_training_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="advance_adjusted_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="retained_amount_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="sales_tax_credit"]').forEach(el => { el.textContent = '0.00'; });
                
                document.querySelectorAll('[data-ds-entity="balance_debit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="advance_adjusted_debit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="retained_amount_used_debit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="receivable_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="cc_tip_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="cc_fee_credit"]').forEach(el => { el.textContent = '0.00'; });
                
                document.querySelectorAll('[data-ds-entity="paid_card"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="paid_check"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="paid_online"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="paid_voucher"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="paid_cash"]').forEach(el => { el.textContent = '0.00'; });
                
                document.querySelectorAll('[data-ds-entity="cash"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="paid_cash_credit"]').forEach(el => { el.textContent = '0.00'; });
                document.querySelectorAll('[data-ds-entity="cc_tip_less"]').forEach(el => { el.textContent = '0.00'; });
                document.getElementById('totalSale').textContent = '0.00';
                document.getElementById('totalTransaction').textContent = '0.00';
                document.getElementById('totalPayments').textContent = '0.00';
                document.getElementById('CashFinal').textContent = '0.00';
                document.getElementById('finalCashInRegister').textContent = '0.00';

            });
    
    document.getElementById('saveCashRegisterBtn').addEventListener('click', function() {
        //Disable Save Button and show spinner
        $("#saveCashRegisterBtn").prop("disabled", true);
        $("#saveCashRegisterSpinner").removeClass("d-none");

        fetch(baseURL + "/saveCashRegister", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    cash_register_date: document.getElementById('dbformatdate').value,
                    remarks: document.getElementById('cashRemarks').value,
                    cash_addition: document.getElementById('cash_addition').value,
                    daily_expense: document.getElementById('daily_expenses').textContent,
                    till_amounts: document.getElementById('today_till').value,
                    register_status: 'open',
                    x5000: document.getElementById('5000span').textContent,
                    // /x2000_count: document.getElementById('2000span').value,
                    x1000: document.getElementById('1000span').textContent,
                    x500: document.getElementById('500span').textContent,
                   // x200_count: document.getElementById('200span').value,
                    x100: document.getElementById('100span').textContent,
                    x75: document.getElementById('75span').textContent,
                    x50: document.getElementById('50span').textContent,
                    x20: document.getElementById('20span').textContent,
                    x10: document.getElementById('10span').textContent,
                    x5: document.getElementById('5span').textContent,
                    x1: document.getElementById('1span').textContent,
                    difference: document.getElementById('totalTillDifference').textContent,


                    
                })
            })
            .then(response => response.json())
            .then(data => {
                //Enable Save Button and hide spinner
                $("#saveCashRegisterBtn").prop("disabled", false);
                $("#saveCashRegisterSpinner").addClass("d-none");

                let btn='btn ' + data.btn_type;
                Swal.fire({
                    title: data.res_type.charAt(0).toUpperCase() + data.res_type.slice(1),
                    text: data.msg,
                    icon: data.res_type,                    
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
               
            });
    });


    window.removeZero = (el) => {
        console.log(el.val());
        if (el.val() === "0") {
            el.val('');
        }
    };

    window.addZero = (el) => {
        if (el.val() === "") {
            el.val('0');
        }
    };

    window.updateCashRegister = (el) => {
       
        if(el.val() === ""){
            return false;
        }

        var x5000 = parseInt($('#5000input').val()) * parseInt($('#5000input').attr('multiplyby'));
        $('#x5000').html(parseFloat(x5000).toFixed(2));
        var x1000 = parseInt($('#1000input').val()) * parseInt($('#1000input').attr('multiplyby'));
        $('#x1000').html(parseFloat(x1000).toFixed(2));
        var x500 = parseInt($('#500input').val()) * parseInt($('#500input').attr('multiplyby'));
        $('#x500').html(parseFloat(x500).toFixed(2));
        var x100 = parseInt($('#100input').val()) * parseInt($('#100input').attr('multiplyby'));
        $('#x100').html(parseFloat(x100).toFixed(2));
        var x75 = parseInt($('#75input').val()) * parseInt($('#75input').attr('multiplyby'));
        $('#x75').html(parseFloat(x75).toFixed(2));
        var x50 = parseInt($('#50input').val()) * parseInt($('#50input').attr('multiplyby'));
        $('#x50').html(parseFloat(x50).toFixed(2));
        var x20 = parseInt($('#20input').val()) * parseInt($('#20input').attr('multiplyby'));
        $('#x20').html(parseFloat(x20).toFixed(2));
        var x10 = parseInt($('#10input').val()) * parseInt($('#10input').attr('multiplyby'));
        $('#x10').html(parseFloat(x10).toFixed(2));
        var x5 = parseInt($('#5input').val()) * parseInt($('#5input').attr('multiplyby'));
        $('#x5').html(parseFloat(x5).toFixed(2));
        var x1 = parseInt($('#1input').val()) * parseInt($('#1input').attr('multiplyby'));
        $('#x1').html(parseFloat(x1).toFixed(2));
        var total_sum = x5000 + x1000 + x500 + x100 + x75 + x50 + x20 + x10 + x5 + x1;

        $('#totalSub').html(parseFloat(total_sum).toFixed(2));

        var cash_addition = parseInt($('#cash_addition').val());
        var yesterday_till = parseInt($('#yesterday_till').text());
        var opening_balance = cash_addition + yesterday_till;
        var totalSub = parseInt($('#totalSub').html());
                        
        $("#totalOpening").text(parseFloat(opening_balance).toFixed(2));
        
        var totalCash = parseInt($('#totalCash').html());
        
        var totalGrand = totalCash + opening_balance;
        $("#totalGrand").text(totalGrand.toFixed(2));
        
        var totalDifference = totalSub - totalGrand;
        var totalTillDifference = totalSub - totalGrand;
        
        if(totalDifference === 0){
            $('#totalDifference').css('color', '#797979');
            $('#difference').css('color', '#797979');
            
            $('#totalDifference').html(parseFloat(totalDifference).toFixed(2));
            
        } else if(totalDifference > 0){
            $('#totalDifference').css('color', 'green');
            $('#difference').css('color', 'green');
            $('#totalDifference').html(parseFloat(totalDifference).toFixed(2));
        } else{
            $('#totalDifference').css('color', 'red');
            $('#difference').css('color', 'red');
            $('#totalDifference').html(parseFloat(totalDifference).toFixed(2));
        }
        
        if(totalTillDifference === 0){
            $('#totalTillDifference').css('color', '#797979');
            $('#difference').css('color', '#797979');
            $('#totalTillDifference').html(parseFloat(totalTillDifference).toFixed(2));
            
        } else if(totalTillDifference > 0){
            $('#totalTillDifference').css('color', 'green');
            $('#difference').css('color', 'green');
            $('#totalTillDifference').html(parseFloat(totalTillDifference).toFixed(2));
        } else{
            $('#totalTillDifference').css('color', 'red');
            $('#difference').css('color', 'red');
            $('#totalTillDifference').html(parseFloat(totalTillDifference).toFixed(2));
        }
        
    };