import $ from 'jquery';

    document.getElementById('till_close_modal').addEventListener('show.bs.modal', function (event) {
        
        let mdate = new Date($('#till_close_modal_date_input').val().split(' ')[0]);

        fetch(baseURL + '/get_till_closing?date=' + $("#calendardate").val().split('T')[0], {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        })
            .then(response => response.json())
            .then(data => {
                console.log(data);
                document.getElementById('tillCloseModalDate').textContent = '';
                document.getElementById('till_close_modal_available_total').textContent = '';

                // Populate the modal with data
                const tbody = document.querySelector('#till_close_modal tbody');
                tbody.innerHTML = ''; // Clear existing rows
                let cash_register = data.cash_register;
                //Check if cash_register status = 'closed' then close the modal and show swall
                if(cash_register != null && cash_register.register_status === 'closed'){
                    let El = document.getElementById('till_close_modal');
                    let modal = bootstrap.Modal.getInstance(El);
                    modal.hide();
                    Swal.fire({
                        title: 'Cash Register Closed',
                        text: 'The cash register for this date is already closed.',
                        icon: 'error',
                        confirmButtonText: 'OK',
                        buttonClass: 'btn btn-danger',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }

                    });
                    return;
                }

                if(cash_register == null){
                    let El = document.getElementById('till_close_modal');
                    let modal = bootstrap.Modal.getInstance(El);
                    modal.hide();
                    Swal.fire({
                        title: 'Cash Register Not Found',
                        text: 'The cash register for this date is not saved yet.',
                        icon: 'error',
                        confirmButtonText: 'OK',
                        buttonClass: 'btn btn-danger',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }

                    });
                    return;
                }

                let row = data.till_account_heads;   

                let denomination_total = cash_register != null ? parseFloat(cash_register.denomination_total) : 0;
                let yesterday_till_amount = data.previous_till_amount != null ? parseFloat(data.previous_till_amount) : 0;
                let tommorrow_till_amount = cash_register != null ? parseFloat(cash_register.till_amounts) : 0;
                let opening_amount = cash_register != null ? parseFloat(cash_register.cash_addition) : 0;
                
                let cash_received = row.paid_cash != null ? parseFloat(row.paid_cash) : 0;
                let cc_tip = row.cc_tip != null ? parseFloat(row.cc_tip) : 0;
                let system_cash_less_tips = cash_received - cc_tip;
                let you_should_have = cash_received - cc_tip + opening_amount + yesterday_till_amount;
                let cash_difference = you_should_have - denomination_total;
                let missing_cash = 0;
                let unaccounted_for = 0;
                if(cash_difference < 0){
                    unaccounted_for = Math.abs(cash_difference);
                } else if(cash_difference > 0){
                    missing_cash = cash_difference;
                }
                let cash_available_for_transfer = denomination_total - tommorrow_till_amount;

                const tr = document.createElement('tr');
                let mHtml = `
                    <td>Till Cash</td>                           
                    <td class='text-end'>${cash_received.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-end'>- ${cc_tip.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-end'>${system_cash_less_tips.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-end'>${yesterday_till_amount.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-end'>${opening_amount.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>                            
                    <td class='text-info fw-bold text-end'>${you_should_have.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-info fw-bold text-end'>${denomination_total.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>                           
                    <td class='text-success text-end'>${tommorrow_till_amount.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-danger fw-bold text-end'>${missing_cash.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-danger fw-bold text-end'>${unaccounted_for.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td class='text-end'>${cc_tip.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</td>
                    <td><select onchange='recalculate_transfer_amount()' class='form-select form-select-sm transfer_select_1' data-max='${cash_available_for_transfer.toFixed(2)}'>
                        `;
                        data.cash_account_heads.forEach(function(cash_account_head) {
                            mHtml += `<option value='${cash_account_head.id_account_heads}'>${cash_account_head.account_head}</option>`;
                        });
                    mHtml += `<option value=''>Select</option></select></td>
                    <td><select onchange='recalculate_transfer_amount()' class='form-select form-select-sm transfer_select_2' data-max='${cash_available_for_transfer.toFixed(2)}'>
                        <option value=''>Select</option>`;
                        data.cash_account_heads.forEach(function(cash_account_head) {
                            mHtml += `<option value='${cash_account_head.id_account_heads}'>${cash_account_head.account_head}</option>`;
                        });
                    mHtml += `</select></td>
                    <td><select onchange='recalculate_transfer_amount()' class='form-select form-select-sm transfer_select_3' data-max='${cash_available_for_transfer.toFixed(2)}'>
                        <option value=''>Select</option>`;
                        data.cash_account_heads.forEach(function(cash_account_head) {
                            mHtml += `<option value='${cash_account_head.id_account_heads}'>${cash_account_head.account_head}</option>`;
                        });
                    mHtml += `</select></td>
                    <td><select onchange='recalculate_transfer_amount()' class='form-select form-select-sm transfer_select_4' data-max='${cash_available_for_transfer.toFixed(2)}'>
                        <option value=''>Select</option>`;
                        data.bank_account_heads.forEach(function(bank_account_head) {
                            mHtml += `<option value='${bank_account_head.id_account_heads}'>${bank_account_head.account_head}</option>`;
                        });
                    mHtml += `</select></td>
                    
                `;
                tr.innerHTML = mHtml; // Remove newlines for cleaner HTML
                const tr1 = document.createElement('tr');
                tr1.innerHTML = `<td colspan="12" class="text-end text-muted">(<i>You Can Move ${cash_available_for_transfer.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",")} to the Bank or upto 3 Different Cash Accounts</i>)</td>
                <td><input onchange='recalculate_transfer_amount()' class='text-end form-control form-control-sm transfer_amount transfer_amount_1' data-transfer=1 type='number' min='0' step='0.01' value='${cash_available_for_transfer.toFixed(2)}' data-max='${cash_available_for_transfer.toFixed(2)}'></td>
                <td><input onchange='recalculate_transfer_amount()' class='text-end form-control form-control-sm transfer_amount transfer_amount_2' data-transfer=2 type='number' min='0' step='0.01' value='0' data-max='${cash_available_for_transfer.toFixed(2)}'></td>
                <td><input onchange='recalculate_transfer_amount()' class='text-end form-control form-control-sm transfer_amount transfer_amount_3' data-transfer=3 type='number' min='0' step='0.01' value='0' data-max='${cash_available_for_transfer.toFixed(2)}'></td>
                <td><input onchange='recalculate_transfer_amount()' class='text-end form-control form-control-sm transfer_amount transfer_amount_4' data-transfer=4 type='number' min='0' step='0.01' value='0' data-max='${cash_available_for_transfer.toFixed(2)}'></td>

                `;
                tbody.appendChild(tr);
                tbody.appendChild(tr1);

                // Set the modal date
                document.getElementById('tillCloseModalDate').textContent = data ? data.till_date : '';
                document.getElementById('till_close_modal_available_total').textContent = cash_available_for_transfer ? cash_available_for_transfer.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",") : '';
            });

    });

    window.recalculate_transfer_amount = function() {
        //disable create_till_closing_voucher
        $('#createTillClosingVoucherButton').prop('disabled', true);
        document.getElementById('createTillClosingVoucherSpinner').classList.remove('d-none');
        console.log('Recalculating transfer amounts...');
        let cash_available_for_transfer = parseFloat($('.transfer_cash_1').attr('data-max'));
        let total_transfer = 0;
        //loop through each transfer amount input and sum the values
        $('.transfer_amount').each(function() {
            let val = parseFloat($(this).val());
            if(!isNaN(val)){
                total_transfer += val;
            }
            if(total_transfer > cash_available_for_transfer){
                toastr.error('Total transfer amount exceeds available cash for transfer of ' + cash_available_for_transfer);
                $(this).val(0);
                total_transfer -= val;
            }
        });
        //enable create_till_closing_voucher
        $('#createTillClosingVoucherButton').prop('disabled', false);
        document.getElementById('createTillClosingVoucherSpinner').classList.add('d-none');
    }

    window.createTillClosingVoucher = function() {
        let transfers = [];
        let cash_available_for_transfer = parseFloat($('.transfer_cash_1').attr('data-max'));
        let total_transfer = 0;
        let valid = true;
        //disable create_till_closing_voucher
        $('#createTillClosingVoucherButton').prop('disabled', true);
        document.getElementById('createTillClosingVoucherSpinner').classList.remove('d-none');

        //loop through each transfer amount input and collect the values
        $('.transfer_amount').each(function() {
            let val = parseFloat($(this).val());
            let data_transfer_id = $(this).attr('data-transfer');
            let transfer_to = $(".transfer_select_" + data_transfer_id).val();
            //console.log(transfer_to);
            if(!isNaN(val) && val > 0){
                if(transfer_to == ''){
                    toastr.error('Please select an account head for the transfer amount of ' + val);
                    valid = false;
                } else {
                    transfers.push({
                        amount: val,
                        to: transfer_to
                    });
                    total_transfer += val;
                }
            }
        });
        if(!valid){
            return;
        }
        if(total_transfer == 0){
            toastr.error('Please enter at least one transfer amount greater than zero.');
            return;
        }
        if(total_transfer > cash_available_for_transfer){
            toastr.error('Total transfer amount exceeds available cash for transfer of ' + cash_available_for_transfer);
            return;
        }
        // Proceed with creating the voucher
        fetch(baseURL + '/create_till_closing_voucher', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            body: JSON.stringify({
                till_date: document.getElementById('till_close_modal_date_input').value,
                total_transfer: total_transfer,
                transfers: transfers
            }),
            dataType: 'json'
        }).then(response => {            
            response.json().then(data => {
                //enable create_till_closing_voucher
                $('#createTillClosingVoucherButton').prop('disabled', false);
                document.getElementById('createTillClosingVoucherSpinner').classList.add('d-none');
                if(data.message_type == 'success'){
                    toastr.success(data.message);
                    let El = document.getElementById('till_close_modal');
                    let modal = bootstrap.Modal.getInstance(El);
                    modal.hide();
                } else {
                    toastr.error(data.message);
                }
            });
            
        });

    }
