/////MODAL FUNCTIONS/////
    document.addEventListener('DOMContentLoaded', function() {
        //get city areas and populate customer_area select
        fetch(baseURL + '/get_city_areas')
        .then(response => response.json())
        .then(data => {
            let options = '<option value="">Select Area</option>';
            data.forEach(area => {
                options += `<option value="${area.id_city_areas}">${area.city_name} - ${area.city_area}</option>`;
            });
            document.getElementById('customer_area').innerHTML = options;

            //initialize select2 after options are populated
            $('#customer_area').select2({
                placeholder: 'Select Area',
                dropdownParent: $('#customerAddModal')
            });

        });

        // Initialize Select2 on the customer_careof select element
        $('#customer_careof').select2({
            placeholder: 'Select Care of',
            dropdownParent: $('#customerAddModal'),                
            minimumInputLength: 3,
            ajax: {
                url: baseURL +'/customer_search',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { term: params.term };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.customer_name || (item.customer_name + ' (' + item.customer_cell + ')'),
                                customer_name: item.customer_name,
                                customer_cell: item.customer_cell,
                                customer_type: item.customer_type // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatCustomer,      // dropdown items
            templateSelection: formatCustomerSel // selected item
            });

    
        function formatCustomer(customer) {
            if (customer.loading) {
                return customer.text;
            }

            var $container = $(`
                <div class="d-flex align-items-center">
                    <div class="me-2">
                        <strong>${customer.customer_name}</strong><br/>
                        <small class="text-muted">${customer.customer_cell}</small>
                    </div>
                </div>
            `);
            return $container;
        }

        function formatCustomerSel(customer) {
            return customer.customer_name || customer.text;
        }

    });    

    document.getElementById('customerAddModal').addEventListener('show.bs.modal', function (event) {        

        let customer_id = document.getElementById('id_customers').value;
        
        if(!customer_id){
            //adding new customer
            //focus on customer name after modal shown
            setTimeout(function(){
                document.getElementById('customer_name').focus();
            }, 500);

            return;
        } else {
            //get customer data and fill the form
            fetch(`${baseURL}/get_customer_edit_data?id_customer=${customer_id}`)
            .then(response => response.json())
            .then(data => {
                console.log(data.id_customers);
                document.getElementById('id_customers').value = data.id_customers;
                document.getElementById('business_id').value = data.business_id;
                document.getElementById('customer_name').value = data.customer_name;
                document.getElementById('customer_cell').value = data.customer_cell;
                document.getElementById('customer_email').value = data.customer_email;
                $('#customer_area').val(data.customer_area).trigger('change');
                document.getElementById('allowed_balance').value = data.allowed_balance;
                document.getElementById('customer_gender').value = data.customer_gender;
                document.getElementById('customer_birthmonth').value = data.customer_birthmonth;
                document.getElementById('customer_birthday').value = data.customer_birthday;
                document.getElementById('customer_type').value = data.customer_type;
                document.getElementById('customer_alert').value = data.customer_alert;
                document.getElementById('customer_allergies').value = data.customer_allergies;
                document.getElementById('customer_address').value = data.customer_address;
                document.getElementById('profession').value = data.profession;
                document.getElementById('customer_card').value = data.customer_card;
                document.getElementById('customer_phone1').value = data.customer_phone1;
                document.getElementById('customer_phone2').value = data.customer_phone2;
                document.getElementById('careof_info').innerText = data.customer_careof;
                // $('#customer_careof').select2('open');
                // $('.select2-search__field').val(data.customer_careof).trigger('input');

                
                //$('#customer_careof').val(data.customer_careof).trigger('change');
            });
        }

    });

    //clear form on modal hide
    document.getElementById('customerAddModal').addEventListener('hide.bs.modal', function (event) {
        //clear form
        clear_form();
    });

    window.add_customer = async function(){
        if(!document.getElementById('customer_name').value){
            toastr.error('Customer Name is required');
            return;
        } else if(document.getElementById('customer_name').value.length < 3){
            toastr.error('Customer Name must be First and Last Names');
            return;
        } else if(!/^[a-zA-Z\s]+$/.test(document.getElementById('customer_name').value)){
            toastr.error('Customer Name must be valid text');
            return;

        } else if(document.getElementById('customer_name').value.toUpperCase().includes('MISS ') || document.getElementById('customer_name').value.toUpperCase().includes('MR ') || document.getElementById('customer_name').value.toUpperCase().includes('MRS ') || document.getElementById('customer_name').value.toUpperCase().includes('MS ') || document.getElementById('customer_name').value.toUpperCase().includes('DR ') || document.getElementById('customer_name').value.toUpperCase().includes('MAM ') || document.getElementById('customer_name').value.toUpperCase().includes('MAAM ')){
            toastr.error('Prefixes such as Mr, Mrs, Miss, Ms are not allowed in Customer Name');
            return;

        } else {
            let nameParts = document.getElementById('customer_name').value.trim().split(' ');
            if(nameParts.length < 2){
                toastr.error('Customer Name must include at least first and last names');
                return;
            } else {
                let firstName = nameParts[0];
                let lastName = nameParts.slice(1).join(' ');
                //make first letter of first and last names capitalized
                firstName = firstName.charAt(0).toUpperCase() + firstName.slice(1);
                lastName = lastName.charAt(0).toUpperCase() + lastName.slice(1);
                document.getElementById('customer_name').value = firstName + ' ' + lastName;
            }
        }

        if(!document.getElementById('customer_cell').value){
            toastr.error('Customer Cell is required');
            return;
        }

        if(!document.getElementById('customer_gender').value){
            toastr.error('Customer Gender is required');
            return;
        }

        if(!document.getElementById('allowed_balance').value){
            document.getElementById('allowed_balance').value = '50000';
        }

        // Check if mobile number already exists (only for new customers)
        let customer_id = document.getElementById('id_customers').value;
        if(!customer_id) {
            // Only check for duplicates when creating a new customer
            let mobileNumber = document.getElementById('customer_cell').value;
            
            // Check mobile number uniqueness via AJAX
            let checkFormData = new FormData();
            checkFormData.append('customer_cell', mobileNumber);
            
            // Get CSRF token from form or meta tag
            let csrfToken = document.querySelector('input[name="_token"]')?.value || 
                            document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            if(csrfToken) {
                checkFormData.append('_token', csrfToken);
            }
            
            try {
                let checkResponse = await fetch(`${baseURL}/customers/check_mobile_exists`, {
                    method: 'POST',
                    body: checkFormData
                });
                
                let checkData = await checkResponse.json();
                
                if(checkData.exists) {
                    Swal.fire({
                        title: 'Duplicate Mobile Number',
                        text: checkData.message,
                        icon: 'error',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                    });
                    return;
                }
            } catch(error) {
                console.error('Error checking mobile number:', error);
                // Continue with form submission if check fails
            }
        }

        console.log('adding customer');
        var formData = new FormData(document.getElementById('customerForm'));
        formData.append('action', 'add_customer');

        let careof_name = document.getElementById('careof_info').innerText;
        formData.append('customer_careof_name', careof_name);

        document.getElementById('saveCustomerButton').disabled = true;
        document.getElementById('saveCustomerSpinner').classList.remove('d-none');

        fetch(`${baseURL}/customers/add_customer`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            console.log(data);
            document.getElementById('saveCustomerButton').disabled = false;
            document.getElementById('saveCustomerSpinner').classList.add('d-none');
            if(data.success){
                toastr.success(data.message);
                let modalEl = document.getElementById('visit-details-modal');
                let modalInstance = bootstrap.Modal.getInstance(modalEl);

                if (modalInstance && modalEl.classList.contains('show')) {

                        // If Visit Details modal is open, update its customer select
                        let $select = $('#visit-details-new-visit-select-customer');

                        // Ensure Select2 is initialized
                        if ($select.data('select2')) {
                            // Open the dropdown
                            $select.select2('open');

                            // Access the search field inside the dropdown
                            let $search = $('.select2-container--open .select2-search__field');

                            // Set the search term
                            $search.val(data.customer_cell).trigger('input');
                        }

                        // Close customer add modal
                        let customerAddModalEl = document.getElementById('customerAddModal');
                        let customerAddModalInstance = bootstrap.Modal.getInstance(customerAddModalEl);
                        if (customerAddModalInstance) {
                            customerAddModalInstance.hide();
                        }
                } else {
                    var posViewEl = document.getElementById('posView');
                    if (posViewEl && posViewEl.value == '1') {
                        var $select2 = $('#for_customer_search_customers');
                        if ($select2.data('select2')) {
                            $select2.select2('open');
                            let $search = $('.select2-container--open .select2-search__field');
                            $search.val(data.customer_cell).trigger('input');
                        }
                        // Close customer add modal
                        let customerAddModalEl = document.getElementById('customerAddModal');
                        let customerAddModalInstance = bootstrap.Modal.getInstance(customerAddModalEl);
                        if (customerAddModalInstance) {
                            customerAddModalInstance.hide();
                        }
                    } else {
                        location.reload();
                    }

                }


            } else {
                document.getElementById('saveCustomerButton').disabled = false;
                document.getElementById('saveCustomerSpinner').classList.add('d-none');
                
                toastr.error('Error: ' + data.message);
            }
        });
    }

    window.clear_form = function(){

        $("#customer_careof").val('').trigger('change');
        document.getElementById('id_customers').value = '';
        document.getElementById('business_id').value = '{{ session("business_id") }}';
        document.getElementById('customer_name').value = '';
        document.getElementById('customer_cell').value = '';
        document.getElementById('customer_email').value = '';
        document.getElementById('customer_area').value = '';
        document.getElementById('allowed_balance').value = '';
        document.getElementById('customer_gender').value = '';
        document.getElementById('customer_birthmonth').value = '';
        document.getElementById('customer_birthday').value = '';
        document.getElementById('customer_type').value = '';
        document.getElementById('customer_alert').value = '';
        document.getElementById('customer_allergies').value = '';
        document.getElementById('customer_address').value = '';
        document.getElementById('profession').value = '';
        document.getElementById('customer_card').value = '';
        document.getElementById('customer_phone1').value = '';
        document.getElementById('customer_phone2').value = '';   
        document.getElementById('careof_info').innerText = '';         
        
    }

    window.updateCareOfSelection = function() {
        
        let data = $("#customer_careof").select2('data')[0];
        console.log(data);
        
        if(data != undefined){
            let id = data ? data.id : "";
            if(id === ""){
                //clear fields
                document.getElementById('customer_cell').value = '';
                document.getElementById('careof_info').innerText = '';
                return;
            }
            let customer_cell = data.customer_cell || '';
            document.getElementById('careof_info').innerText = data.customer_name;
            document.getElementById('customer_cell').value = customer_cell;
        }
    }